// Solution by team Phoenix (1st place in spectators).
// Solution submitted after 54 minutes.
//package D;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class D_Phoenix {

    static Map<String, Team> teamMap = new HashMap<>();
    static List<Team> teams = new ArrayList<>();

    public static void main(String[] args) throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
//        BufferedReader reader = new BufferedReader(new FileReader("D2.txt"));
        int numTeams = Integer.parseInt(reader.readLine());
        long numLines = (numTeams * (numTeams - 1)) / 2;

        for (int i = 0; i < numLines; i++) {
            String[] line = reader.readLine().split(" ");
            String team1 = line[0];
            if (!teamMap.containsKey(team1)) {
                newTeam(team1);
            }
            Team t1 = teamMap.get(team1);
            String team2 = line[1];
            if (!teamMap.containsKey(team2)) {
                newTeam(team2);
            }
            Team t2 = teamMap.get(team2);
            long points1 = Long.parseLong(line[2]);
            long points2 = Long.parseLong(line[3]);
            if (points1 > points2) {
                t1.points += 3;
            } else if (points1 < points2) {
                t2.points += 3;
            } else {
                t1.points += 1;
                t2.points += 1;
            }
        }

//        teams.sort(Comparator.comparingInt(a -> a.points));
        teams.sort((a, b) -> {
            if (a.points == b.points) {
                return b.name.compareTo(a.name);
            }
            return a.points - b.points;
        });
        for (int i = teams.size() - 1; i >= 0 && i >= teams.size() - 5; i--) {
            System.out.println(teams.get(i).name + " " + teams.get(i).points);
        }
    }

    static void newTeam(String teamName) {
        Team team = new Team(teamName, 0);
        teams.add(team);
        teamMap.put(teamName, team);
    }

    static class Team {
        String name;
        int points;

        public Team(String name, int points) {
            this.name = name;
            this.points = points;
        }
    }
}
