//
// Created by Dragos Paul Vecerdea on 09/06/2020.
//
#include <iostream>
#include <unordered_map>
#include <set>
using namespace std;

struct comp
{
    template<typename T>
    bool operator()(const T& l, const T& r) const
    {
        if (l.second != r.second)
            return l.second > r.second;

        return l.first < r.first;
    }
};

int main() {
    int n;
    std::unordered_map<string, int> teams;
    cin >> n;
    n = n * (n-1) / 2;
    for(int i=0 ;i<n;i++) {
        string A,B;
        int scoreA,scoreB;
        cin >> A >> B >> scoreA >> scoreB;
        int addA, addB;
        addA = scoreA-scoreB > 0 ? 3 : (scoreB == scoreA ? 1 : 0);
        addB = scoreB-scoreA > 0 ? 3 : (scoreA == scoreB ? 1 : 0);
        teams[B]+=addB;
        teams[A]+=addA;
    }
    set<std::pair<string,int>, comp> leaderboard(teams.begin(), teams.end());
    int top = 5;
    for (pair<string,int> team : leaderboard) {
        if(top == 0) break;
        cout << team.first << ' ' << team.second << '\n';
        top--;
    }
}