// Solution by team Phoenix (1st place in spectators).
// Solution submitted after 74 minutes.
//package F;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.InputStreamReader;
import java.util.*;

public class F_Phoenix {
    public static void main(String[] args) throws Exception {
        BufferedReader bf = new BufferedReader(new InputStreamReader(System.in));
//        BufferedReader bf = new BufferedReader(new FileReader(new File("X:\\Documents\\tud\\fpc-2020\\samples\\F\\1.in")));

        new F_Phoenix().solve(bf);
    }

    private void solve(BufferedReader bf) throws Exception {
        int n = Integer.parseInt(bf.readLine());
        int[] widths = new int[n + 1];

        String earliest = bf.readLine().strip();
        Map<String, Node> nodes = new HashMap<>();
        nodes.put(earliest, new Node(earliest));

        for (int i = 0; i < n - 1; i++) {
            String[] split = bf.readLine().split(" - ");
            String A = split[0];
            String B = split[1];

            if(!nodes.containsKey(A)) {
                nodes.put(A, new Node(A));
            }
            if(!nodes.containsKey(B)) {
                nodes.put(B, new Node(B));
            }
            nodes.get(A).kids.add(nodes.get(B));
        }

        Node current = nodes.get(earliest);
        Queue<Node> explore = new LinkedList<>();
        Queue<Integer> depth = new LinkedList<>();
        explore.add(current);
        depth.add(0);
        Set<Node> visited = new HashSet<>();
        visited.add(current);

        while(!explore.isEmpty()) {
            Node curNode = explore.poll();
            int d = depth.poll();
            widths[d]++;
            for (Node kid: curNode.kids) {
                if (!visited.contains(kid)) {
                    explore.add(kid);
                    depth.add(d + 1);
                    visited.add(kid);
                }
            }
        }

        int res = 0;
        for (int i = 0; i <= n; i++) {
            res = Math.max(res, widths[i]);
        }
        System.out.println(res);
    }

    class Node {
        String id;
        Set<Node> kids;

        public Node(String id) {
            this.kids = new HashSet<>();
            this.id = id;
        }
    }
}
