import java.io.*;
import java.util.*;
import java.util.stream.*;

public class F_Correct {
    public static void main(String[] args) {
        Scanner sc = new Scanner(new BufferedReader(new InputStreamReader(System.in)));
        new F_Correct().run(sc);
        sc.close();
    }

    public void run(Scanner sc) {
        System.out.println(calculateWidth(sc));
    }

    public int calculateWidth(Scanner sc) {
        int n = sc.nextInt();
        Map<String, List<String>> edges = new HashMap<>();
        Map<String, Integer> widthOfChildren = new HashMap<>();
        String root = sc.next();
        for (int i = 0; i < n - 1; i++) {
            String parent = sc.next();
            sc.next(); // "-"
            String child = sc.next();

            edges.putIfAbsent(parent, new ArrayList<>());
            edges.get(parent).add(child);
            widthOfChildren.putIfAbsent(parent, 0);
            widthOfChildren.putIfAbsent(child, 0);
            widthOfChildren.put(parent, widthOfChildren.get(parent) + 1);
        }

        int max = 1;
        List<String> nextLevel = new ArrayList<>(1);
        nextLevel.add(root);
        while (!nextLevel.isEmpty()) {
            max = Integer.max(max, nextLevel.stream().mapToInt(widthOfChildren::get).sum());
            nextLevel = nextLevel.stream()
                    .flatMap(s -> edges.containsKey(s) ? edges.get(s).stream() : Stream.empty())
                    .collect(Collectors.toList());
        }
        return max;
    }
}
