#!/usr/bin/env python3

import random
import string

random.seed(4242424242)
characters = string.ascii_letters + string.digits


def gen_password():
    return "".join(random.choice(characters) for _ in range(32))


with open("../data/secret/n_1000_all_equal.in", "w") as fp:
    correct = gen_password()
    fp.write("1000\n")
    fp.write(correct + "\n")
    for _ in range(1000):
        fp.write(correct + " ALLOWED\n")
with open("../data/secret/n_1000_all_equal.ans", "w") as fp:
    fp.write("SYSTEM SECURE\n")

with open("../data/secret/n_1000_all_wrong.in", "w") as fp:
    correct = "".join(random.choice(characters) for _ in range(32))
    fp.write("1000\n")
    fp.write(gen_password() + "\n")
    for _ in range(1000):
        fp.write(gen_password() + " DENIED\n")
with open("../data/secret/n_1000_all_wrong.ans", "w") as fp:
    fp.write("SYSTEM SECURE\n")

with open("../data/secret/n_1000_all_one_off.in", "w") as fp:
    correct = gen_password()
    fp.write("1000\n")
    fp.write(correct + "\n")
    for _ in range(1000):
        password = list(correct)
        password[random.randint(0, 31)] = random.choice(characters)
        fp.write("".join(password) + " ALLOWED\n")
with open("../data/secret/n_1000_all_one_off.ans", "w") as fp:
    fp.write("SYSTEM SECURE\n")

