import java.io.*;
import java.util.*;

public class NoLengthCheck {
    public static void main(String[] args) throws IOException {
        Scanner sc = new Scanner(new BufferedReader(new InputStreamReader(System.in)));
        new NoLengthCheck().run(sc);
        sc.close();
    }

    public void run(Scanner sc) {
        int n = sc.nextInt();
        String correct = sc.next();
        for (int i = 0; i < n; i++) {
            String password = sc.next();
            String status = sc.next();
            if (almostEqual(correct, password) && status.equals("DENIED") ||
                    !almostEqual(correct, password) && status.equals("ALLOWED")) {
                System.out.println("INTEGRITY OVERFLOW");
                return;
            }
        }

        System.out.println("SYSTEM SECURE");
    }

    private boolean almostEqual(String password1, String password2) {
        boolean oneMistake = false;
        for (int i = 0; i < password2.length(); i++) {
            if (password1.charAt(i) != password2.charAt(i)) {
                if (oneMistake)
                    return false;
                else
                    oneMistake = true;
            }
        }
        return true;
    }
}
