#!/usr/bin/env python3


def almost_equal(password1, password2):
    return len(password1) == len(password2) and \
           sum(0 if c1 == c2 else 1 for c1, c2 in zip(password1, password2)) <= 1


n = int(input())
correct = input()
for _ in range(n):
    password, status = input().split()
    if almost_equal(correct, password) and status == "DENIED" or \
            not almost_equal(correct, password) and status == "ALLOWED":
        print("INTEGRITY OVERFLOW")
        exit()

print("SYSTEM SECURE")
