import java.util.*

enum class Ops {
    mov,
    add,
    sub,
    jeq,
    hcf
}

fun main() {
    val input = Scanner(System.`in`)

    val program = ArrayList<String>()
    repeat(input.nextLine().toInt()) {
        program.add(input.nextLine())
    }

    runProgram(program)
}

fun runProgram(prog: List<String>) {
    var debug = -1

    val environment = HashMap<String, Int>()
    environment["pc"] = 0
    environment["cmp"] = 0
    environment["acc"] = 0
    environment["out"] = 0
    while(environment["pc"]!! < prog.size && environment["pc"]!! >= 0) {
        val cmd = parseLine(prog[environment["pc"]!!])
        val argA = cmd.second.first
        val argB = cmd.second.second

        when(cmd.first) {
            Ops.mov -> environment[argB.substring(1)] = parseArg(argA, environment)
            Ops.add -> opAddSub(argA, argB, environment)
            Ops.sub -> opAddSub(argA, argB, environment, true)
            Ops.jeq -> {
                if (parseArg(argA, environment) == environment["cmp"]) {
                    environment["pc"] = parseArg(argB, environment) - 1
                }
            }
            Ops.hcf -> {
                debug = environment["pc"]!!
                environment["pc"] = -999
            }
        }
        environment["pc"] = environment["pc"]!!+1
    }

    if(debug > -1) {
        println(prog[debug])
        println(environment["acc"]!!)
        println(environment["cmp"]!!)
        println(environment["out"]!!)
    } else {
        println(environment["out"]!!)
    }
}

fun parseLine(line: String): Pair<Ops,Pair<String,String>> {
    val args = line.split(" ")
    return Pair(Ops.valueOf(args[0]), Pair(args[1],args[2]))
}

fun parseArg(arg: String, env: HashMap<String, Int>): Int {
    if(arg.contains('$')) {
        return env[arg.substring(1)] ?: 0
    } else {
        return arg.toInt()
    }
}

fun opAddSub(argA: String, argB: String, env: HashMap<String, Int>, sub: Boolean = false) {
    if(sub) {
        env["acc"] = parseArg(argA, env) - parseArg(argB, env)
    } else {
        env["acc"] = parseArg(argA, env) + parseArg(argB, env)
    }
}