// Solution by our coach, Verwoerd (2st place in spectators).
// Solution submitted after 130 minutes.
fun main() {
  readLine()
  System.`in`.bufferedReader().readLines().forEachIndexed { index, line ->
    val (command, opl, opr) = line.split(" ")
    code[index] = Triple(command, opl, opr)
  }

  loop@ while (pc >= 0 && pc < code.size) {

    val (command, left, right) = code[pc]!!

    when (command) {
      "mov" -> {
        when (right) {
          "\$acc" -> acc = parseParameter(left)
          "\$pc" -> pc = parseParameter(left)
          "\$cmp" -> cmp = parseParameter(left)
          "\$out" -> out = parseParameter(left)
          else -> parameters[right] = parseParameter(left)
        }
      }
      "add" -> acc = parseParameter(left) + parseParameter(right)
      "sub" -> acc = parseParameter(left) - parseParameter(right)
      "jeq" -> if (cmp == parseParameter(left)) pc = parseParameter(right) - 1
      "hcf" -> {
        println("$command $left $right")
        println(acc)
        println(cmp)
        break@loop
      }
      else -> error("invalid op code")
    }
    pc++
  }
  println(out)
}

var acc = 0
var pc = 0
var cmp = 0
var out = 0
var parameters = mutableMapOf<String, Int>().withDefault { 0 }
val code = mutableMapOf<Int, Triple<String, String, String>>()

fun parseParameter(parameter: String): Int = when {
  parameter.startsWith("$") -> when (parameter) {
    "\$acc" -> acc
    "\$pc" -> pc
    "\$cmp" -> cmp
    "\$out" -> out
    else -> parameters.getValue(parameter)
  }
  else -> parameter.toInt()
}

