// Solution by team Phoenix (1st place in spectators).
// Solution submitted after 25 minutes.
//package H;

import java.io.*;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class H_Phoenix {
    Map<String, Integer> vars;
    public static void main(String[] args) throws Exception {
        BufferedReader bf = new BufferedReader(new InputStreamReader(System.in));
        //BufferedReader bf = new BufferedReader(new FileReader(new File("X:\\Documents\\tud\\fpc-2020\\samples\\H\\2.in")));

        new H_Phoenix().solve(bf);
    }

    private void solve(BufferedReader bf) throws Exception {
        int n = Integer.parseInt(bf.readLine());


        String[][] opps = new String[n][3];
        for (int i = 0; i < n; i++) {
            String[] split = bf.readLine().split(" ");
            for (int j = 0; j < split.length; j++) {
                opps[i][j] = split[j].strip();
            }
        }



        this.vars = new HashMap<>();
        vars.put("$pc", 0);
        vars.put("$acc", 0);
        vars.put("$cmp", 0);
        vars.put("$out", 0);
        while (vars.get("$pc") < opps.length && vars.get("$pc") >= 0) {
            String[] opp = opps[vars.get("$pc")];
            switch(opp[0]) {
                case "mov":
                    int from = getValue(opp[1]);
                    vars.put(opp[2], from);
                    incrementPC();
                    break;
                case "add":
                    int a = getValue(opp[1]);
                    int b = getValue(opp[2]);
                    vars.put("$acc", a+b);
                    incrementPC();
                    break;
                case "sub":
                    a = getValue(opp[1]);
                    b = getValue(opp[2]);
                    vars.put("$acc", a-b);
                    incrementPC();
                    break;
                case "jeq":
                    int cmp = getValue("$cmp");
                    int val = getValue(opp[1]);
                    if (val == cmp) {
                        vars.put("$pc", getValue(opp[2]));
                    } else {
                        incrementPC();
                    }
                    break;
                case "hcf":
                    System.out.printf("%s %s %s\n", opp[0], opp[1], opp[2]);
                    System.out.printf("%s\n%s\n%s\n", vars.get("$acc"), vars.get("$cmp"), vars.get("$out"));
                    return;
            }

        }

        System.out.println(vars.get("$out"));
    }

    private Integer incrementPC() {
        return vars.put("$pc", vars.get("$pc") + 1);
    }


    private int getValue(String s) {
        if (s.startsWith("$")) {
            return this.vars.get(s);
        }
        return Integer.parseInt(s);
    }
}
