import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public class TestCaseGenerator {
	
	private static class Edge {
		int fr;
		int to;
		
		private Edge(int fr, int to) {
			this.fr = fr;
			this.to = to;
		}
	}

	public static void main(String[] args) throws IOException {
		int MAX_N = 1000000, MAX_M = 100000;
		Random r = new Random();
		int n = r.nextInt(MAX_N - 1) + 2;
		int m = r.nextInt(MAX_M) + 1;
		System.out.println(n + " " + m);
		List<Edge> edges = new ArrayList<>();
		StringBuilder sb = new StringBuilder();
		sb.append(n);
		sb.append(' ');
		sb.append(m);
		sb.append('\n');
		File file = new File("test-input.in");
		file.createNewFile();
		FileWriter fw = new FileWriter(file);
		
		for (int i = 1; i <= m; ++ i) {
			System.out.println(i);
			int a, b;
			boolean found = false;
			while (!found) {
				a = r.nextInt(n - 1) + 1;
				b = r.nextInt(n - 1) + 1;
				while (a == b) {
					b = r.nextInt(n - 1) + 1;
				}
				
				if (a > b) {
					int temp = a;
					a = b;
					b = temp;
				}
				
				boolean lamp = false;
				for (Edge e: edges) {
					if ((e.fr < a && a < e.to && e.to < b) ||
							(a < e.fr && e.fr < b && b < e.to)) {
						lamp = true;
						break;
					}
				}
				
				if (!lamp) {
					edges.add(new Edge(a, b));
					found = true;
					sb.append(a);
					sb.append(' ');
					sb.append(b);
					sb.append('\n');
				}
			}
		}
		
		fw.write(sb.toString());
		fw.flush();
		fw.close();
		System.out.println("Done!");
	}
}
