import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;

public class Banitsa {
	
	static List<Integer>[] connected;
	static int n, m;
	static boolean color[];
	static boolean used[];
	
	
	static void read(Scanner sc) {
		connected = new ArrayList[n + 1];
		color = new boolean[n + 1];
		used = new boolean[n + 1];
		
		for(int i = 1; i <= n; ++ i) {
			connected[i] = new ArrayList<>();
		}
		
		for(int i = 0; i < m; ++ i) {
			connected[i] = new ArrayList<>();
		}
		
		for(int i = 0; i < m; ++ i) {
			int a = sc.nextInt();
			int b = sc.nextInt();
			
			connected[a].add(b);
			connected[b].add(a);
		}
	}
	
	static boolean isBipartite(int v, boolean col) {
		used[v] = true;
		color[v] = col;
		
		int sz = connected[v].size();
		for(int i = 0; i < sz; ++ i) {
			int next = connected[v].get(i);
			if(!used[next]) {
				if(!isBipartite(next, !col)) {
					return false;
				}
			}
			else if(color[next] == color[v]) {
				return false;
			}
		}
		
		return true;
	}

	public static void main(String[] args) {
		Scanner sc = new Scanner(System.in);
		n = sc.nextInt();
		m = sc.nextInt();
		read(sc);
		
		for(int i = 1; i <= n; ++ i) {
			if(!used[i]) {
				if(!isBipartite(i, false)) {
					System.out.println(3);
					return;
				}
			}
		}
		
		System.out.println(2);
		
	}

}
