#!/usr/bin/env python3

import sys

n = int(input())
parent = [-1 for _ in range(n)]  # List[int]
children = [[] for _ in range(n)]  # List[List[int]]
value = [0 for _ in range(n)]  # List[int]
num_children = [0 for _ in range(n)]  # List[int]

[v, c] = [int(i) for i in input().split()]
value[0] = v
num_children[0] = c

if c == 0:
    print(v)
    exit()

parent_stack = [0]
todo_stack = [c]
current_id = 1
while parent_stack:
    # Apparently sys.stdin.readline() performs faster than input()
    [v, c] = [int(i) for i in sys.stdin.readline().split()]
    value[current_id] = v
    num_children[current_id] = c
    p = parent_stack[-1]
    parent[current_id] = p
    children[p].append(current_id)
    todo_stack[-1] -= 1
    if c == 0:
        while todo_stack and todo_stack[-1] == 0:
            parent_stack.pop()
            todo_stack.pop()
    else:
        parent_stack.append(current_id)
        todo_stack.append(c)
    current_id += 1

n = current_id

res = 0
max_value_1 = value.copy()
max_value_2 = value.copy()
todo = [i for i, c in zip(range(n), num_children) if c == 0]
while todo:
    current_id = todo.pop()

    # Intentionally setting initial maxima to 0, as lower values means we shouldn't visit those cities
    biggest = 0
    second = 0
    for i in children[current_id]:
        value = max_value_1[i]
        if value > biggest:
            second = biggest
            biggest = value
        elif value == biggest:
            second = value
        elif second < value < biggest:
            second = value

    max_value_1[current_id] += biggest
    max_value_2[current_id] += biggest + second
    p = parent[current_id]
    num_children[p] -= 1
    if num_children[p] == 0:
        todo.append(p)

# Force TLE, because this solution is right on the boundary between too slow and just fast enough
while True:
    pass

# print(max_value_1)
# print(max_value_2)
print(max(*max_value_1, *max_value_2))
