// Solution by team Phoenix (1st place in spectators).
// Solution submitted after 109 minutes.
//package E;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.*;

public class E_Phoenix {

    Map<Integer, Integer> parents = new HashMap<>();
    Map<Integer, Set<Integer>> children = new HashMap<>();
    Map<Integer, Integer> values = new HashMap<>();
    long bestPath = Long.MIN_VALUE;
    Map<Integer, Long> bestHalfPath = new HashMap<>();

    public static void main(String[] args) throws Exception {
        BufferedReader bf = new BufferedReader(new InputStreamReader(System.in));
//        BufferedReader bf = new BufferedReader(new FileReader(new File("X:\\Documents\\tud\\fpc-2020\\samples\\A\\1.in")));

        new E_Phoenix().solve(bf);
    }

    private int parse(BufferedReader bf, int parent, int id) throws Exception {
        String[] split = bf.readLine().split(" ");
        int V = Integer.parseInt(split[0]);
        int C = Integer.parseInt(split[1]);

        values.put(id, V);
        if (parent != -1) {
            parents.put(id, parent);
        }
        children.put(id, new HashSet<>());

        int nextId = id + 1;
        for (int c = 0; c < C; c++) {
            children.get(id).add(nextId);
            nextId = parse(bf, id, nextId);
        }

        return nextId;
    }

    private void solve(BufferedReader bf) throws Exception {
        /*int n =*/ Integer.parseInt(bf.readLine());
        parse(bf, -1, 0);
        recursePath(0);
        System.out.println(bestPath);
    }

    private void recursePath(int nodeId) {
        int nodeValue = values.get(nodeId);
        long bestLocalPath = nodeValue;
        for (Integer childId : children.get(nodeId)) {
            recursePath(childId);
            long childPath = bestHalfPath.get(childId);
            bestLocalPath = Math.max(bestLocalPath, childPath + nodeValue);
        }
        bestHalfPath.put(nodeId, bestLocalPath);
        bestPath = Math.max(bestPath, bestLocalPath);

        // Check for paths contained in this subtree if there are 2+ children
        if (children.get(nodeId).size() >= 2) {
            long bestSubTree = Long.MIN_VALUE;
            long secondSubTree = Long.MIN_VALUE;
            for (Integer childId : children.get(nodeId)) {
                long childPath = bestHalfPath.get(childId);
                if (childPath > bestSubTree) {
                    secondSubTree = bestSubTree;
                    bestSubTree = childPath;
                } else if (childPath > secondSubTree) {
                    secondSubTree = childPath;
                }
            }
            long totalValue = bestSubTree + secondSubTree + nodeValue;
            bestPath = Math.max(bestPath, totalValue);
        }
    }
}
