import java.io.FileNotFoundException;
import java.util.*;

class A_ship_goes_outside_map {
    static int n,m,l;
    static int[][] map;
    static int[][] horizontalMap;
    static int maxHeight = 0;
    static class Position {
        int x,y;

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (!(o instanceof Position)) return false;
            Position position = (Position) o;
            return x == position.x &&
                    y == position.y;
        }

        @Override
        public int hashCode() {
            return Objects.hash(x, y);
        }

        public Position(int x, int y) {
            this.x = x;
            this.y = y;
        }
        static int[] moveX = {0,0,1,-1};
        static int[] moveY = {1,-1,0,0};
        public Position move(int dir) {
            return new Position(this.x + moveX[dir], this.y + moveY[dir]);
        };
        public boolean validate(int height) {
            //mistake here should be L
            if(this.x < 1) return false;
            if(this.y < 1) return false;
            if(this.x > n) return false;
            if(this.y > m) return false;
            return map[this.x][this.y] < height;
        }
        public boolean isDestination() {
            return this.x == n && this.y == m;
        }
    }
    public static boolean isPossible(int height) {
        Position startPos = new Position(l,l);
        if(!startPos.validate(height)) return false;
        Queue<Position> q = new LinkedList<>();
        Set<Position> visited = new HashSet<>();
        q.add(startPos);
        visited.add(startPos);
        while(!q.isEmpty()) {
            Position currPos = q.remove();
            if (currPos.isDestination()) return true;
            for(int dir = 0; dir < 4; dir++) {
                Position nextPos = currPos.move(dir);
                if(nextPos.validate(height) && !visited.contains(nextPos)) {
                    visited.add(nextPos);
                    q.add(nextPos);
                }
            }
        }
        return false;
    }

    public static void slidingWindowHorizontal() {
        for(int i=1; i<=n; i++) {
            Deque<Integer> deque = new LinkedList<>();
            for(int j=1; j<=m; j++) {
                while(deque.size() > 0 && map[i][deque.getLast()] <= map[i][j]) {
                    deque.removeLast();
                }
                deque.add(j);
                while(deque.getFirst()+l<=j) {
                    deque.removeFirst();
                }
                horizontalMap[i][j] = map[i][deque.getFirst()];
            }
        }
    }

    public static void slidingWindowVertical() {
        for(int j=1; j<=m; j++) {
            Deque<Integer> deque = new LinkedList<>();
            for(int i=1;i<=n;i++) {
                while(deque.size() > 0 && horizontalMap[deque.getLast()][j] <= horizontalMap[i][j]) {
                    deque.removeLast();
                }
                deque.addLast(i);
                while(deque.size() > 0 && deque.getFirst()+l<=i) {
                    deque.removeFirst();
                }
                map [i][j] = horizontalMap[deque.getFirst()][j];
            }
        }
    }

    public static int binarySearch() {
        int start = 0;
        int step = 1<<29;
        while(step > 0) {

            int testHeight = start + step;
            if(testHeight <= maxHeight && !isPossible(testHeight)) {
                start += step;
            }
            step/=2;
        }
        return start;
    }

    public static void readMap(Scanner sc, int n, int m) {
        for(int i = 1; i<=n; i++) {
            for(int j = 1; j<=m;j ++) {
                map[i][j] = sc.nextInt();
                if(maxHeight < map[i][j]) {
                    maxHeight = map[i][j];
                }
            }
        }
    }

    public static void main(String[] args) throws FileNotFoundException {
        Scanner sc = new Scanner(System.in);
        n = sc.nextInt();
        m = sc.nextInt();
        l = sc.nextInt();
        map=new int[n+1][m+1];
        horizontalMap = new int[n+1][m+1];
        readMap(sc, n,m);
        slidingWindowHorizontal();
        slidingWindowVertical();
        System.out.println(binarySearch()+1);
    }
}