import java.io.*;
import java.util.*;

public class BitSetNaive {
    public static void main(String[] args) {
        Scanner sc = new Scanner(new BufferedReader(new InputStreamReader(System.in)));
        new BitSetNaive().run(sc);
        sc.close();
    }

    public void run(Scanner sc) {
        int n = sc.nextInt(), m = sc.nextInt();
        int[] buttons = new int[m];
        for (int i = 0; i < m; i++) {
            buttons[i] = sc.nextInt();
        }
        BitSet reachable = new BitSet(n + 1);
        for (int button : buttons) {
            int i = 0;
            while (i != -1 && i + button < n) {
                reachable.set(i + button);
                i = reachable.nextSetBit(i + 1);
            }
        }
        System.out.println(reachable.cardinality());
    }
}
