import java.util.*;
public class C_accepted {

    public static class Node implements Comparator<Node> {
        private int node;
        private int cost;
        public Node(int node, int cost) {
            this.cost = cost;
            this.node = node;
        }
        public int compare(Node a, Node b) {
            return a.cost - b.cost;
        }
        public int getNode() {
            return this.node;
        }
        public int getCost() {
            return this.cost;
        }
    }
    public static class Graph {
        static private List<Node>[] edges;
        static private Integer[] firstTimes;
        static private Integer smallest_button;
        static private long counter;

        public static void createGraph(List<Integer> buttons) {
            smallest_button = Collections.min(buttons);
            edges = new ArrayList[smallest_button];
            for(int mod = 0; mod < smallest_button; mod ++) {
                edges[mod] = new ArrayList<>();
                for(Integer button : buttons) {
                    Node newNode = new Node((mod + button) % smallest_button, button);
                    edges[mod].add(newNode);
                }
            }
        }

        public static void dijkstra() {
            firstTimes = new Integer[smallest_button];
            firstTimes[0] = 0;
            for(int i = 1; i < smallest_button; i++) {
                firstTimes[i] = Integer.MAX_VALUE;
            }
            Set<Integer> visited = new HashSet<>();
            PriorityQueue<Node> pq = new PriorityQueue<>(new Node(0,0));
            Node startNode = new Node(0, 0);
            pq.add(startNode);
            visited.add(0);
            while (!pq.isEmpty()) {
                Node currNode = pq.remove();
                for(Node nbrNode : edges[currNode.getNode()]) {
                    Integer newCost = firstTimes[currNode.getNode()] + nbrNode.getCost();
                    if(!visited.contains(nbrNode.getNode()) && firstTimes[nbrNode.getNode()] > newCost) {
                        pq.add(new Node(nbrNode.getNode(), newCost));
                        firstTimes[nbrNode.getNode()] = newCost;
                    }
                }
            }
        }

        public static void countSeconds(int movieLength) {
            counter = 0;
            for(Integer firstTime : firstTimes) {
                if(firstTime < movieLength) {
                    if(firstTime != 0) counter += 1;
                    counter += (movieLength-firstTime-1)/smallest_button;
                }
            }
        }
    }

    public static void main(String[] args) {
        Scanner sc = new Scanner(System.in);
        int n, m;
        n = sc.nextInt();
        m = sc.nextInt();
        List<Integer> buttons = new ArrayList<>();
        for(int i = 0; i < m; i++) {
            buttons.add(sc.nextInt());
        }
        Graph.createGraph(buttons);
        Graph.dijkstra();
        Graph.countSeconds(n);
        System.out.println(Graph.counter);
    }
}
