#!/usr/bin/env python3
# Solution by team geen idee (5th place).
# Solution submitted after 151 minutes (first solve).

import sys
import math


class vector:

    def __init__(self, x, y, z):
        self.x, self.y, self.z = x, y, z

    def length(self):
        return math.sqrt(self.dot(self))

    def normalized(self):
        length = self.length()
        if length == 0:
            return vector(0,0,0)
        return vector(self.x / length, self.y / length, self.z / length)

    def dot(self, other):
        return self.x * other.x + self.y * other.y + self.z * other.z

    def __sub__(self, other):
        return vector(self.x - other.x, self.y - other.y, self.z - other.z)

    def __add__(self, other):
        return vector(self.x + other.x, self.y + other.y, self.z + other.z)

    def __mul__(self, other):
        return vector(self.x * other, self.y * other, self.z * other)


if __name__ == '__main__':
    n = int(input())

    h = vector(*(float(x) for x in input().rsplit()))
    v = vector(*(float(x) for x in input().rsplit()))

    total = 0

    for _ in range(n):
        two_vectors = [float(x) for x in input().rsplit()]
        p = vector(*two_vectors[:3])
        d = vector(*two_vectors[3:])

        q_p = (p - h.normalized() * p.dot(h.normalized()) - v.normalized() * p.dot(v.normalized()))
        q_d = (d - h.normalized() * d.dot(h.normalized()) - v.normalized() * d.dot(v.normalized()))

        if q_d.length() == 0:
            continue

        time = q_p.length() / q_d.length()

        if q_p.dot(q_d) < 0:
            hp = p + d * time
            z = hp.dot(h.normalized()) / h.length()
            y = hp.dot(v.normalized()) / v.length()

            if (z**2 + y**2 <= 1):
                total += 1

    print(total)
