#include <iostream>
#include <cmath>

int main() {
	double n, h1, h2, h3, v1, v2, v3, p1, p2, p3, d1, d2, d3;
	std::cin >> n >> h1 >> h2 >> h3 >> v1 >> v2 >> v3;

	int hits = 0;

	double n1 = h2 * v3 - v2 * h3,
				 n2 = h3 * v1 - v3 * h1,
				 n3 = h1 * v2 - v1 * h2;

	for (int i = 0; i < n; i++) {
		std::cin >> p1 >> p2 >> p3 >> d1 >> d2 >> d3;

		double dProjection = d1 * n1 + d2 * n2 + d3 * n3;

		if (fabs(dProjection) < 1e-4) continue;

		double pProjection = p1 * n1 + p2 * n2 + p3 * n3;
		double length = -pProjection / dProjection;

		if (length < 0)	continue;

		double i1 = p1 + d1 * length,
					 i2 = p2 + d2 * length,
					 i3 = p3 + d3 * length;

		double hFactor = (i1 * h1 + i2 * h2 + i3 * h3) / (h1 * h1 + h2 * h2 + h3 * h3),
					 vFactor = (i1 * v1 + i2 * v2 + i3 * v3) / (v1 * v1 + v2 * v2 + v3 * v3);
		if ((hFactor * hFactor + vFactor * vFactor) < 1) hits++;
	}
	std::cout << hits << std::endl;
	return 0;
}
