import java.io.FileWriter;
import java.io.IOException;
import java.util.*;
import java.util.stream.Collectors;

public class GenerateTrees {

    static Random random = new Random(253894625);

    static int[][] problems = {
            // n, e
            {20, 3},
            {100, 5},
            {1000, 10},
            {10_000, 50},
            {100_000, 100},
            {1_000_000, 500},
    };

    public static void main(String[] args) throws IOException {
        for (int[] problem : problems) {
            String tree = generateTree(problem);
            long answer = new F_Correct().calculateLength(new Scanner(tree));
            FileWriter file = new FileWriter("../data/secret/" + problemName(problem) + ".in");
            file.write(tree);
            file.close();
            file = new FileWriter("../data/secret/" + problemName(problem) + ".ans");
            file.write(answer + "\n");
            file.close();
        }
    }

    private static String generateTree(int[] problem) {
        int n = problem[0], e = problem[1];
        List<Integer> intersections = new ArrayList<>(n);
        for (int i = 1; i <= n; i++) {
            intersections.add(i);
        }
        Collections.shuffle(intersections, random);

        List<Integer> entrances = intersections.subList(0, e);
        List<Integer> done = new ArrayList<>(intersections.subList(0, e));
        List<List<Integer>> tree = new ArrayList<>(n + 1);
        for (int i = 0; i <= n; i++) {
            tree.add(new ArrayList<>());
        }
        for (int i = e; i < n; i++) {
            Integer j = intersections.get(i);
            tree.get(done.get(random.nextInt(done.size()))).add(j);
            done.add(j);
        }

        StringBuilder sb = new StringBuilder();
        sb.append(n).append(' ').append(e).append('\n');
        sb.append(entrances.stream().map(a -> "" + a).collect(Collectors.joining(" "))).append('\n');
        for (int i = 1; i <= n; i++) {
            List<Integer> children = tree.get(i);
            sb.append(children.size());
            for (Integer child : children) {
                sb.append(' ').append(child);
            }
            sb.append('\n');
        }
        return sb.toString();
    }

    private static String problemName(int[] problem) {
        return "n_" + problem[0] + "_e_" + problem[1];
    }
}
