#include <iostream>
#include <queue>
#include <vector>

using namespace std;

int main() {
    int n, m, s;
    cin >> n >> m >> s;

    bool shrooms[n + 1];
    fill(shrooms, shrooms + n + 1, false);
    shrooms[1] = shrooms[n] = true;
    for (int i = 0, l; i < s - 2; i++) {
        cin >> l;
        shrooms[l] = true;
    }

    vector<vector<int>> intersections;
    for (int i = 0; i < n + 1; i++)
        intersections.push_back(vector<int>());

    for (int i = 0, a, b; i < m; i++) {
        cin >> a >> b;
        if (!shrooms[a] || !shrooms[b])
            continue; // Only add roads between intersections that have shrooms
        intersections[a].push_back(b);
        intersections[b].push_back(a);
    }

    int previous[n + 1];
    previous[1] = -1;
    fill(previous, previous + n + 1, 0);
    queue<int> queue;
    queue.push(1);
    while (!queue.empty()) {
        int intersection = queue.front();
        queue.pop();
        vector<int> neighbours = intersections[intersection];
        for (vector<int>::iterator it = neighbours.begin(); it != neighbours.end(); it++) {
            int neighbour = *it;
            if (previous[neighbour] != 0)
                continue; // We have already explored this intersection
            queue.push(neighbour);
            previous[neighbour] = intersection;
            if (neighbour == n) {
                goto end;
            }
        }
    }

end:
    vector<int> path;
    path.push_back(n);
    while (path.back() != 1) {
        path.push_back(previous[path.back()]);
    }
    cout << path.size() << endl;
}
