import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.*;

public class BalloonPartyMaarten {
    public static void main(String[] args) {
        Scanner sc = new Scanner(new BufferedReader(new InputStreamReader(System.in)));
        new BalloonPartyMaarten().run(sc);
        sc.close();
    }

    public void run(Scanner sc) {
        int w = sc.nextInt();
        int l = sc.nextInt();
        sc.nextLine();

        int[][] tent = new int[w][l];
        for (int i = 0; i < l; i++) {
            String[] heights = sc.nextLine().split(" ");
            for (int j = 0; j < w; j++) {
                tent[j][i] = Integer.parseInt(heights[j]);
            }
        }

        PriorityQueue<Position> pq = new PriorityQueue<>(Comparator.comparingInt(a -> -a.h));
        for (int j = 0; j < w; j++) {
            pq.add(new Position(j, 0, tent));
            pq.add(new Position(j, l - 1, tent));
        }
        for (int j = 0; j < l; j++) {
            pq.add(new Position(0, j, tent));
            pq.add(new Position(w - 1, j, tent));
        }

        boolean[][] done = new boolean[w][l];
        int[][] mins = new int[w][l];
        while (!pq.isEmpty()) {
            Position p = pq.poll();
            if (done[p.x][p.y])
                continue;
            floodFill(p.x, p.y, w, l, p.h, tent, mins, done, pq);
        }

        int ans = 0;
        for (int i = 0; i < w; i++) {
            for (int j = 0; j < l; j++) {
                ans += tent[i][j] - mins[i][j];
            }
        }
        System.out.println(ans);
    }

    private void floodFill(int x, int y, int w, int l, int from, int[][] tent, int[][] mins, boolean[][] done, PriorityQueue<Position> pq) {
        Stack<Position> floodStack = new Stack<>();
        floodStack.add(new Position(x, y, tent));
        while (!floodStack.isEmpty()) {
            Position current = floodStack.pop();
            x = current.x;
            y = current.y;
            done[x][y] = true;
            mins[x][y] = from;

            if (x > 0 && !done[x - 1][y])
                if (from <= tent[x - 1][y])
                    floodStack.add(new Position(x - 1, y, tent));
                else
                    pq.add(new Position(x - 1, y, tent));

            if (x < w - 1 && !done[x + 1][y])
                if (from <= tent[x + 1][y])
                    floodStack.add(new Position(x + 1, y, tent));
                else
                    pq.add(new Position(x + 1, y, tent));

            if (y > 0 && !done[x][y - 1])
                if (from <= tent[x][y - 1])
                    floodStack.add(new Position(x, y - 1, tent));
                else
                    pq.add(new Position(x, y - 1, tent));

            if (y < l - 1 && !done[x][y + 1])
                if (from <= tent[x][y + 1])
                    floodStack.add(new Position(x, y + 1, tent));
                else
                    pq.add(new Position(x, y + 1, tent));
        }
    }

    static class Position {
        final int x;
        final int y;
        final int h;

        public Position(int x, int y, int[][] h) {
            this.x = x;
            this.y = y;
            this.h = h[x][y];
        }
    }
}
