#include "stdio.h"

int min(int a, int b) {
	return a<b?a:b;
}

int main () {
	int N, S, M;
	scanf("%d %d", &N, &S);

	long** matrix = new long*[N];
	for(int i = 0; i < N; i++) {
		matrix[i] = new long[N];
		for(int j = 0; j <= N; j++) {
			matrix[i][j] = 1<<29;
		}
	}

	for(int i=0;i<S;i++) {
		int a,b,l;
		scanf("%d %d %d", &a, &b, &l);
		if(matrix[a-1][b-1] != 1<<29) {
			printf("%d %d\n", a, b);
		}
		matrix[a-1][b-1] = l;
		matrix[b-1][a-1] = l;
	}

	matrix[0][0] = 0;

	for(int k=0; k<N; k++) {
		for(int i=0; i<N; i++) {
			for(int j=0; j<N; j++) {
				matrix[i][j] = min(matrix[i][j], matrix[i][k] + matrix[k][j]);
			}
		}
	}

	scanf("%d", &M);
	int bestDist = 1<<30, bestShop=-1;
	for(int i=0;i<M;i++) {
		int c;
		scanf("%d", &c);
		if((matrix[0][c-1] < bestDist) || (matrix[0][c-1] == bestDist && c < bestShop)) {
			bestDist = matrix[0][c-1];
			bestShop = c;
		}
	}

	printf("%d %d\n", bestShop, bestDist);
	return 0;
}



