import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class B_Generator {

    private static int[][] problems = new int[][]{
            {1, 5},
            {3, 10},
            {5, 3},
            {9, 100},
            {11, 121},
            {101, 999},
            {101, 9999},
            {501, 299_999},
            {999, 999_999},
    };

    public static void main(String[] args) throws IOException {
        for (int[] problem : problems) {
            int n = problem[0], m = problem[1];
            String[][] grid = generateGrid(n);
            String[] events = generateEvents(m, n);
            String answer = new B_correct().calculateBingo(n, m, grid, events);
//            verify(n, events, answer);
            FileWriter file = new FileWriter("../data/secret/" + n + "_" + m + ".in");
            file.write(n + " " + m + "\n");
            for (String[] strings : grid) {
                file.write(String.join(" ", strings));
                file.write("\n");
            }
            for (String event : events) {
                file.write(event);
                file.write("\n");
            }
            file.close();
            file = new FileWriter("../data/secret/" + n + "_" + m + ".ans");
            file.write(answer + "\n");
            file.close();
        }
    }

    // NOTE: only works with n < 10
    private static void verify(int n, String[] events, String answer) {
        int ans = Integer.parseInt(answer);
        char[][] sheet = new char[n][n];
        for (int i = 0; i < n; i++) {
            for (int j = 0; j < n; j++) {
                sheet[i][j] = ' ';
            }
        }
        for (int i = 0; i < events.length && i < ans; i++) {
            String event = events[i];
            try {
                int x = Integer.parseInt(event.charAt(0) + "");
                int y = Integer.parseInt(event.charAt(1) + "");
                if (x < n && y < n) {
                    sheet[x][y] = 'X';
                }
            } catch (Exception ignored) {
            }
            if (i == ans - 2 || i == ans - 1) {
                for (char[] chars : sheet) {
                    System.out.println(new String(chars));
                }
                System.out.println();
            }
        }
    }

    private static String[] generateEvents(int m, int n) {
        List<String> res = new ArrayList<>(n * n * 2);
        int n1 = Integer.max(n + 1, (int) Math.ceil(Math.sqrt(m + 1)));
        for (int i = 0; i < n1; i++) {
            for (int j = 0; j < n1; j++) {
                if (i == n / 2 && j == n / 2) continue;
                res.add(newString(i, n1) + newString(j, n1));
            }
        }
        Collections.shuffle(res);
        return res.subList(0, m).toArray(new String[0]);
    }

    private static String[][] generateGrid(int n) {
        String[][] res = new String[n][n];
        for (int i = 0; i < n; i++) {
            for (int j = 0; j < n; j++) {
                res[i][j] = newString(i, n) + newString(j, n);
            }
        }
        return res;
    }

    private static String newString(int i, int n) {
        char[] res = new char[(int) Math.ceil(Math.log(n + 1) / Math.log(62))];
        for (int j = 0; j < res.length; j++) {
            int c = i % 62;
            if (0 <= c && c <= 9) c += '0';
            else if (10 <= c && c <= 35) c += 'A' - 10;
            else c += 'a' - 36;
            res[j] = (char) c;
            i /= 62;
        }
        return new String(res);
    }

}

