import java.io.IOException;
import java.util.Scanner;

public class CheckGuessGame {
	public static final String USER_OUTPUT = "OVER";
	public static final String JURY_OUTPUT = "TARGET";
	public static void main(String[] args) throws IOException{
		if (args.length < 2) {
			System.err.printf("error: not enough arguments: 2 required\n");
			System.exit(1);
		}
		for(int i = 2; i < args.length;i++){
			System.err.printf("Extra arg %d = %s\n", i, args[i]);
		}
		Scanner sc = new Scanner(System.in);
		String jury = null;
		String user = null;
		while(sc.hasNextLine()){
			String line = sc.nextLine();
			if(line.startsWith(USER_OUTPUT)){
				user = line;
			} else if(line.startsWith(JURY_OUTPUT)){
				jury = line;
			}
		}
		if(jury == null){
			System.out.println("No "+JURY_OUTPUT+", user time limit or runjury time limit");
		} else if(user == null){
			System.out.println("No "+USER_OUTPUT+" received");
		} else if(!user.replace(USER_OUTPUT, JURY_OUTPUT).equals(jury)){
			System.out.println("Wrong answer: "+user.replace(USER_OUTPUT, "")+" != "+jury.replace(JURY_OUTPUT, ""));
		} else{
			System.err.println("Correct answer");
			System.err.println("Jury answer: "+jury);
			System.err.println("User answer: "+user);
		}
	}
}
