import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.util.Locale;
import java.util.Random;
import java.util.Scanner;

public class genTestsC {

    public static void main(String[] args) throws FileNotFoundException {
//        generate();
        check();
    }

    public static void generate() throws FileNotFoundException {
        for (int i = 1; i <= 10; i++) {
            PrintWriter in = new PrintWriter(new FileOutputStream(i + ".in"));

            Random random = new Random(System.currentTimeMillis());
            int length = random.nextInt(980) + 20;
            int numStudents = 1 + random.nextInt((i * 1000) - 1);

            boolean doomed = random.nextBoolean();

            if (i == 10) {
                numStudents = 10000;
                doomed = true;
            }

            System.out.println(doomed ? "gen doomed" : "gen ok");

            float fastest = random.nextFloat() * (3600 - 2) + 2;
            float avgSpeed = (length * 2) / fastest;

            in.println(length);
            in.println(numStudents);
            in.println(fastest);

            for (int j = 0; j < numStudents; j++) {
                float mins = 0.1f;
                float maxs = 1000.0f;
                if (doomed) {
                    maxs = avgSpeed - 0.01f;
                }

                float avgRspeed = random.nextFloat() * (maxs - mins) + mins;

//                System.out.println(avgRspeed);
                float miss = avgRspeed - 0.1f;
                float randMiss = random.nextFloat() * (miss - 0.1f) + 0.1f;
                in.println((avgRspeed - randMiss) + " " + (avgRspeed + randMiss));
            }

            in.flush();
            in.close();

        }
    }

    public static void check() throws FileNotFoundException {
        for (int n = 1; n <= 10; n++) {
            Scanner sc = new Scanner(new File(n + ".in"));
            sc.useLocale(Locale.ENGLISH);
            int SKPLength = sc.nextInt();
            int numberOfStudents = sc.nextInt();
            float bestTimeMeasured = sc.nextFloat();

            PrintWriter in = new PrintWriter(new FileOutputStream(n + ".out"));
            boolean done = false;

            for (int i = 0; i < numberOfStudents; i++) {
                float frontCrawlSpeed = sc.nextFloat();
                float backCrawlSpeed = sc.nextFloat();
                float averageSpeed = (frontCrawlSpeed + backCrawlSpeed) / 2.0f;

                // Don't forget that you have to return! 2 times the length thus.
                if ((SKPLength * 2) / averageSpeed < bestTimeMeasured) {
                    System.out.println("HOPE");
                    in.println("HOPE");
                    in.flush();
                    in.close();
                    done = true;
                    break;
                }
            }
            if(done) { continue; }
            System.out.println("DOOMED");
            in.println("DOOMED");
            in.flush();
            in.close();
        }
    }
}
