package A;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.Scanner;

/*
 Notes:
    - "no point in playing"?
    - Not clear what you should print if the game is over, but consistent.
 */

/**
 * Created by stefan on 3/11/16.
 */
public class AStefanSolution {

    class Game {
        int playA;
        int playB;
        int id;

        public Game(int playA, int playB, int id) {
            this.playA = playA;
            this.playB = playB;
            this.id = id;
        }

        public boolean wonA() {
            return this.playA  -2 >= this.playB && this.playA >= 11;
        }

        public boolean wonB() {
            return this.playB  -2> this.playA && this.playB >= 11;
        }

        public boolean isDone() {
            return wonA() || wonB();
        }

        public boolean needsTiebreak() {
            return this.playA >= 10 && this.playB >= 10;
        }

        public boolean isConsistent() {
            if (needsTiebreak()) {
                if (wonA() && this.playA - 2 > this.playB) {
                    return false;
                } else if (wonB() && this.playB - 2 > this.playA) {
                    return false;
                }
            } else {
                if (this.playB > 11 || this.playA > 11) {
                    return false;
                }
            }
            return true;
        }

        public int updatePlayer(int player) {
            int result = player % 2;
            if (!this.needsTiebreak()) {
                int sum = (playA+playB) % 4;
                if (sum < 2) {
                    return result;
                } else {
                    return 1 - result;
                }
            } else {
                int sum = (playA + playB) - 20;
                return (result + sum) %2;
            }
        }
    }

    public static void main(String[] args) throws FileNotFoundException {
		Scanner sc = new Scanner(System.in);
        new AStefanSolution().solve(sc);
    }

    public void solve(Scanner sc) {
        int numGames = Integer.parseInt(sc.nextLine());
        Game games[] = new Game[numGames];
        int winsA = 0, winsB = 0;
        String line = sc.nextLine();
        String[] split = line.split(" ");
        for (int i = 0; i < numGames; i++) {
            String[] nums = split[i].trim().split("-");
            int a = Integer.parseInt(nums[0]);
            int b = Integer.parseInt(nums[1]);
            games[i] = new Game(a,b,i);
            if (games[i].wonA()) {
                winsA++;
            } else if (games[i].wonB()) {
                winsB++;
            }

            if (!games[i].isConsistent() || (i < numGames-1 && !games[i].isDone())) {
                System.out.println("INCONSISTENT");
                return;
            }
        }

        if (winsA >= 3 || winsB >= 3 ) {
            System.out.println("INCONSISTENT");
            return;
        }
        int isHost = games[numGames-1].updatePlayer((numGames-1) %2);
        if (isHost > 0) {
           System.out.println("GUEST");
        } else {
            System.out.println("HOST");
        }
    }

}
