import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;

public class AChr {
	
	static class Game{
		int a, b;
		
		public Game(){
			
		}
		
		public Game(String[] scores){
			a = Integer.parseInt(scores[0]);
			b = Integer.parseInt(scores[1]);
		}
		
		public String toString(){
			return a+"-"+b;
		}
	}
	
	public static void main(String[] args) throws IOException{
		Scanner sc = new Scanner(System.in);
		solve(sc);
	}
	
	public static void solve(Scanner sc){
		int n = sc.nextInt();
		List<Game> games = new ArrayList<>();
		while (n --> 0) games.add(new Game(sc.next().split("-")));
		System.err.println(games);
		boolean inconsistent = false;
		int aWin = 0;
		int bWin = 0;
		for(int i = 0; i < games.size();i++){
			boolean currentGame = i == games.size() - 1;
			Game g = games.get(i);
			if(g.a > g.b) aWin++;
			else bWin++;
			if(!currentGame && Math.abs(g.a - g.b) < 2){
				System.err.println(g+" Not enough point difference.");
				inconsistent = true;
			}
			if(Math.abs(g.a - g.b) > 2 && Math.max(g.a, g.b) > 11){
				System.err.println(g+" Game already won.");
				inconsistent = true;
			}
			if(!currentGame && Math.max(g.a, g.b) < 11){
				System.err.println(g+" Game not over.");
				inconsistent = true;
			}
		}
		if(Math.abs(aWin - bWin) > 2){
			System.err.println("Player already won.");
			inconsistent = true;
		}
		if(inconsistent){
			System.out.println("INCONSISTENT");
		} else{
			boolean hostStart = games.size() % 2 == 0;
			String starter = null;
			System.err.println("Host start = "+hostStart);
			Game cur = games.get(games.size() - 1);
			System.err.println("Serving game "+cur);
			if(cur.a + cur.b >= 20){
				if((cur.a + cur.b) % 2 == 0) starter = hostStart ? "GUEST" : "HOST";
				else starter = hostStart ? "HOST" : "GUEST";
			} else{
				if((cur.a + cur.b) % 4 == 0 || (cur.a + cur.b + 1) % 4 == 0) starter = hostStart ? "HOST" : "GUEST";
				else starter = hostStart ? "GUEST" : "HOST";
			}
			if(starter != null){
				System.out.println(starter);
			}
		}
	}
}
