import java.util.*;
import java.io.*;

public class B {
    public static boolean[] isPrime;
    public static ArrayList<Integer> primes;
    public static Random generator;
        
	public static void main(String[] args) throws Exception {
	    generator = new Random(300);
	    //generate();
	    solve();
	}
	
	public static void generate() throws Exception{
	    primes = new ArrayList<Integer>();
	    int nprimes = 1000;
	    makeSieve(nprimes);
	    int lb = 100;
	    for( int i = lb; i <= nprimes; i++ )
	        if( isPrime[i] )
	            primes.add( i );
	    
	    for( int i = 1; i <= 10; i++ ){
	        File ft = new File("testcases/"+i+".in");
	        FileWriter ftw = new FileWriter(ft.getAbsoluteFile());
            BufferedWriter btw = new BufferedWriter(ftw);
	        long p = primes.get((int) (generator.nextDouble()*(primes.size())));
	        long q = primes.get((int) (generator.nextDouble()*(primes.size())));
	        long e = primes.get((int) (generator.nextDouble()*(primes.size())));
	        long n = p*q;
	        if( n < 0 ){
	            i--; continue;
            }
            long phi = (p-1)*(q-1);
            long msg = (long) (100+generator.nextDouble()*899);
            btw.write(p+" "+q+" "+e+"\n");
            System.out.println("Testcase "+i+":");
            System.out.println(p+" "+q+" "+e);
            System.out.println(msg);
            long enc = powMod(msg,e,n);
            long dec = solve(p,q,e,msg);
            btw.write(msg+"\n");
            btw.close();
            System.out.println("Decrypt: "+dec);
            System.out.println("Encrypt: "+powMod(dec,e,n));
            System.out.println();
            
            ft = new File("testcases/"+i+".out");
	        ftw = new FileWriter(ft.getAbsoluteFile());
            btw = new BufferedWriter(ftw);
            btw.write(dec+"\n");
            btw.close();
	    }
	}
	
	public static void makeSieve(int N) {
        isPrime = new boolean[N + 1];
        // initially assume all integers are prime
        for (int i = 2; i <= N; i++) {
            isPrime[i] = true;
        }

        // mark non-primes <= N using Sieve of Eratosthenes
        for (int i = 2; i*i <= N; i++) {

            // if i is prime, then mark multiples of i as nonprime
            // suffices to consider mutiples i, i+1, ..., N/i
            if (isPrime[i]) {
                for (int j = i; i*j <= N; j++) {
                    isPrime[i*j] = false;
                }
            }
        }

        // count primes
        int primes = 0;
        for (int i = 2; i <= N; i++) {
            if (isPrime[i]) primes++;
        }
	}
	
	public static void solve() {
		Scanner sc = new Scanner(System.in);
		long p = sc.nextInt();
		long q = sc.nextInt();
		long e = sc.nextInt();
		long msg = sc.nextInt();
		System.out.println(solve(p, q, e, msg));
	}
		
	public static long solve(long p, long q, long e, long msg) {
		long phi = (p-1)*(q-1);
		long d = -1;
		for( int i = 1; i < phi; i++ )
		{
		    if( (i * e) % phi == 1 )
		    {
		        d = i;
		        break;
		    }
		}
		//System.out.println("msg = "+msg);
		//System.out.println("n = "+(p*q));
		//System.out.println("d = "+d);
		//System.out.println("intPowMod: "+intPowMod((int)msg,(int)d,(int)(p*q)));
		return powMod(msg,d,p*q);
	}
	
    public static long powMod(long b, long e, long m) {
        long res = 1;
        for( int i = 0; i < e; i++ )
        {
            res = (res*b) % m;
        }
        return res;
    }
    
    public static int intPowMod(int b, int e, int m) {
        int res = 1;
        for( int i = 0; i < e; i++ )
        {
            res = (res*b) % m;
        }
        return res;
    }
    
    public static int intPow(int b, int e, int m) {
        int res = 1;
        for( int i = 0; i < e; i++ )
        {
            res = (res*b);
        }
        return res%m;
    }
}
