// Solution to Jumbled Letters
// Author: Thomas Beuman

// Time complexity: O(10 * 2^10 * log n)
// Memory: O(n)

// @EXPECTED_RESULTS@: CORRECT

/*
Solution outline:

For all words, sort the letters. Link these to the original words using a map.
For every case, sort the letters and try all subsets.
Look for a match in the letter-sorted dictionary.
*/

#include <cstdio>
#include <string>
#include <map>
#include <algorithm>
using namespace std;

map<string,string> Dictionary;

// Compare words, return the best one
string best (string a, string b)
{ return a.size() > b.size() || (a.size() == b.size() && a < b) ? a : b;
}

int main()
{ int cases, casenr, n, m, s, i;
  char letters[11];
  string word, sorted, subset;
  scanf("%d\n", &n);
  for (i = 0; i < n; i++)
  { scanf("%s\n", letters);
    word = sorted = letters;
    sort(sorted.begin(), sorted.end()); // Sort the letters
    if (!Dictionary.count(sorted)) // See if it's already present; if so, ignore
      Dictionary[sorted] = word; // Link sorted word to original word
  }
  scanf("%d\n", &cases);
  for (casenr = 1; casenr <= cases; casenr++)
  { scanf("%s\n", letters);
    sorted = letters;
    sort(sorted.begin(), sorted.end()); // Sort the letters
    m = sorted.size();
    word = "";
    // Try all subsets
    for (s = 0; s < (1 << m); s++)
    { subset = "";
      // Construct subset
      for (i = 0; i < m; i++)
        if (s & (1 << i))
          subset += sorted[i];
      if (Dictionary.count(subset)) // Check the dictionary
        word = best(word, Dictionary[subset]); // If found, check if it's better
    }
    printf("%s\n", word == "" ? "IMPOSSIBLE" : word.c_str());
  }
  return 0;
}

