/*
 * @EXPECTED_RESULTS@: CORRECT
 */
using System;
using System.Collections.Generic;

public class jeroen
{
	public static void Main(string[] args)
	{
		int N = int.Parse(Console.ReadLine());
		Dictionary<string,string> dict = new Dictionary<string,string>();
		string prev = "";
		for(int i = 0; i < N; i++)
		{
			string w = Console.ReadLine();
			if(w.CompareTo(prev) <= 0) throw new Exception("Words are not sorted!");
			string norm = NormalForm(w, (1<<w.Length) - 1);
			if(!dict.ContainsKey(norm))
				dict.Add(norm, w);
			prev = w;
		}
		int T = int.Parse(Console.ReadLine());
		for(int i = 0; i < T; i++)
		{
			string letters = Console.ReadLine();
			string ans = "IMPOSSIBLE";
			for(int mask = 1; mask < (1<<letters.Length); mask++)
			{
				string norm = NormalForm(letters, mask);
				if (dict.ContainsKey(norm) && (ans == "IMPOSSIBLE" || norm.Length > ans.Length || (norm.Length == ans.Length && dict[norm].CompareTo(ans) < 0)))
					ans = dict[norm];
			}
			Console.WriteLine(ans);
		}
	}

	public static string NormalForm(string s, int mask)
	{
		char[] ret = new char[NumBits(mask)];
		int i = 0;
		for(int j = 0; j < s.Length; j++)
			if((mask & (1<<j)) > 0)
				ret[i++] = s[j];
		Array.Sort(ret);
		return new string(ret);
	}

	public static int NumBits(int i)
	{
		int res = 0;
		while(i > 0)
		{
			res += i & 1;
			i >>= 1;
		}
		return res;
	}
}