// Solution to Islands
// Author: Thomas Beuman

// Time complexity: O(n^2*m^2)
// Memory: O(n*m + n^2)

// @EXPECTED_RESULTS@: CORRECT

// Solution method: determine the distances between all pairs of polygons and do Dijkstra

#include <cstdio>
#include <cmath>
#include <algorithm>
using namespace std;

typedef double dbl; // Use long double for greater accuracy

int M[50], X[50][50], Y[50][50];
dbl Dis[50][50], Mindis[50];
bool Processed[50];

// Returns the shortest path (over water) between two polygons
dbl dijkstra (int n, int from, int to)
{ int i, k;
  for (i = 0; i < n; i++)
  { Mindis[i] = 1e9; // Shortest distance (provisional)
    Processed[i] = false;
  }
  Mindis[from] = 0;
  while (true)
  { // Look for unprocessed polygon with shortest distance
    k = -1;
    for (i = 0; i < n; i++)
      if (!Processed[i] && (k < 0 || Mindis[i] < Mindis[k]))
        k = i;
    // Shortest distance to k is final
    if (k == to) // Finished
      return Mindis[k];
    Processed[k] = true;
    // Update distance to all unprocessed polygons
    for (i = 0; i < n; i++)
      if (!Processed[i])
        Mindis[i] = min(Mindis[i], Mindis[k] + Dis[i][k]);
  }
}

// Returns distance between the point (xp,yp)
//   and the line segment between (x1,y1) and (x2,y2)
dbl dis_pt_line (int xp, int yp, int x1, int y1, int x2, int y2)
{ int dx12 = x1-x2, dx1p = x1-xp, dx2p = x2-xp;
  int dy12 = y1-y2, dy1p = y1-yp, dy2p = y2-yp;
  if (dx12*dx1p + dy12*dy1p < 0)
    return sqrt(dx1p*dx1p + dy1p*dy1p); // Distance between (xp,yp) and (x1,y1)
  if (-dx12*dx2p - dy12*dy2p < 0)
    return sqrt(dx2p*dx2p + dy2p*dy2p); // Distance between (xp,yp) and (x2,y2)
  // Distance between (xp,yp) and its projection on the line (x1,y1)-(x2,y2)
  return abs(dx12*dy1p - dx1p*dy12) / sqrt(dx12*dx12 + dy12*dy12);
}

// Returns distance between two polygons
dbl dis_polygons (int m1, int X1[], int Y1[], int m2, int X2[], int Y2[])
{ int i, j;
  dbl dis = 1e9;
  // Try every possible combination of vertex and edge, find minimum
  for (i = 0; i < m1; i++)
    for (j = 0; j < m2; j++)
    { dis = min(dis, dis_pt_line(X1[i], Y1[i], X2[j], Y2[j], X2[(j+1)%m2], Y2[(j+1)%m2]));
      dis = min(dis, dis_pt_line(X2[j], Y2[j], X1[i], Y1[i], X1[(i+1)%m1], Y1[(i+1)%m1]));
    }
  return dis;
}

int main()
{ int cases, casenr, n, s, d, i, j;
  scanf("%d\n", &cases);
  for (casenr = 1; casenr <= cases; casenr++)
  { // Read input
    scanf("%d\n%d %d\n", &n, &s, &d);
    for (i = 0; i < n; i++)
    { scanf("%d\n", &M[i]);
      for (j = 0; j < M[i]; j++)
        scanf("%d %d\n", &X[i][j], &Y[i][j]);
    }
    // Determine the distance between all pairs of polygons
    for (i = 1; i < n; i++)
      for (j = 0; j < i; j++)
        Dis[i][j] = Dis[j][i] = dis_polygons(M[i], X[i], Y[i], M[j], X[j], Y[j]);
    printf("%.3lf\n", dijkstra(n, s-1, d-1));
    //printf("%.3lf\n", dijkstra(n, s-1, d-1) + 2e-6); // Check for rounding problems
  }
  return 0;
}

