/*
@EXPECTED_RESULTS@: CORRECT

Approach:
To compute the distance between two polygons, it suffices to consider only the
distances between a vertex of one polygon and an edge of another.

The distance between a point and an endge can be calculated by projecting the
point onto the line through the edge, clipping it within range of the endpoints
of edge, and then calculating the distance between the point and its projection.

When the minimum distance between each pairs of polygons is known, the shortest
path from the start region to the destination region is the answer. */

#include <stdio.h>
#include <math.h>

#define REP(i, n) for (i = 0; i < n; ++i)

static double min(double x, double y) { return x < y ? x : y; }

/* Calculates the distance from point (x,y) to line segment (x1,y1)-(x2,y2). */
static double distance( double x, double y,
                        double x1, double y1, double x2, double y2 )
{
    double pos;
    x -= x1, x2 -= x1;
    y -= y1, y2 -= y1;
    pos = (x*x2 + y*y2)/(x2*x2 + y2*y2);
    if (pos < 0) pos = 0;
    if (pos > 1) pos = 1;
    return hypot(x2*pos - x, y2*pos - y);
}

int main()
{
    int cases = 0;
    scanf("%d", &cases);
    while (cases-- > 0)
    {
        int N, M[50], X[50][50], Y[50][50], S, D;
        double E[50][50];
        int i, j, k, l;

        /* Read input. */
        scanf("%d", &N);
        scanf("%d %d", &S, &D);
        REP(i, N) {
            scanf("%d", &M[i]);
            REP(k, M[i]) scanf("%d %d", &X[i][k], &Y[i][k]);
        }

        /* Compute distance between each pair of polygonal regions: */
        REP(i, N) REP(j, N) E[i][j] = 1e99;
        REP(i, N) REP(j, N) REP(k, M[i]) REP(l, M[j]) {
            int m = (l + 1)%M[j];
            E[i][j] = E[j][i] = min(E[i][j],
                distance(X[i][k], Y[i][k], X[j][l], Y[j][l], X[j][m], Y[j][m]));
        }

        /* Compute shortest paths using Floyd–Warshall algorithm: */
        REP(k, N) REP(i, N) REP(j, N) E[i][j] = min(E[i][j], E[i][k] + E[k][j]);

        /* Write output (length of shortest path from S to D): */
        printf("%.3f\n", E[S - 1][D - 1]);
    }
    return 0;
}
