/*
 * @EXPECTED_RESULTS@: CORRECT
 */
import java.io.*;
import java.util.*;

public class jeroen2
{
	public static void main(String[] args)
	{
		Scanner sc = new Scanner(System.in);
		int tests = sc.nextInt();
		while (tests-- > 0)
		{
			Point luke = new Point(sc);
			Point escape = new Point(sc);
			int n = sc.nextInt();
			Point[] points = new Point[n+2];
			points[0] = luke;
			points[1] = escape;
			for(int i = 0; i < n; i++)
				points[i+2] = new Point(sc);
			Point[] hull = ConvexHull(points, true).toArray(new Point[] { });
			int start = 0;
			while(start < hull.length && hull[start] != luke) start++;
			int end = 0;
			while(end < hull.length && hull[end] != escape) end++;
			if(start == hull.length && end == hull.length)
				System.out.println("IMPOSSIBLE");
			else if(start == hull.length || end == hull.length)
			{
				Point[] points2 = new Point[n+1];
				System.arraycopy(points, 1, points2, 0, n+1);
				points2[0] = start == hull.length ? luke : escape;
				LinkedList<Point> hull2 = ConvexHull(points2, true);
				if((start == hull.length && hull2.contains(luke))
					 || (end == hull.length && hull2.contains(escape)))
					System.out.println(String.format("%.3f", Distance(luke,escape) - 1e-6));
				else
					System.out.println("IMPOSSIBLE");
			}
			else
			{
				double dst1 = 0;
				for(int i = start; i != end; i = (i+1)%hull.length)
					dst1 += Distance(hull[i], hull[(i+1)%hull.length]);
				double dst2 = 0;
				for(int i = start; i != end; i = (i+hull.length-1)%hull.length)
					dst2 += Distance(hull[i], hull[(i+hull.length-1)%hull.length]);
				System.out.println(String.format("%.3f", Math.min(dst1, dst2) - 1e-6));
			}
		}
	}

	private static class Point
	{
		public int X, Y;
		
		public Point(Scanner sc)
		{
			X = sc.nextInt();
			Y = sc.nextInt();
		}
	}

	public static double Distance(Point A, Point B)
	{
		return Math.sqrt((long)(A.X - B.X) * (A.X - B.X) + (long)(A.Y - B.Y) * (A.Y - B.Y));
	}


	/* Calculates convex hull of a set of poins */
	public static LinkedList<Point> ConvexHull(Point[] points, boolean onEdge)
	{
		int p = 0, i, start, n;
		long cr, dist, d;
		int N = points.length;
		boolean[] used = new boolean[N];

		for (i = 1; i < N; i++)
			if (points[i].X < points[p].X || (points[i].X == points[p].X && points[i].Y > points[p].Y))
				p = i;

		LinkedList<Point> ret = new LinkedList<Point>();
		start = p;
		do
		{
			n = -1;
			dist = onEdge ? Long.MAX_VALUE : 0;
			for (i = 0; i < N; i++)
			{
				if (i == p || used[i]) continue;
				if (n == -1) n = i;
				cr = (long)(points[i].X - points[p].X) * (points[n].Y - points[p].Y) - (long)(points[i].Y - points[p].Y) * (points[n].X - points[p].X);
				d = (long)(points[i].X - points[p].X) * (points[i].X - points[p].X) + (long)(points[i].Y - points[p].Y) * (points[i].Y - points[p].Y);
				if (cr < 0 || (cr == 0 && i != start && ((onEdge && d < dist) || (!onEdge && d > dist))))
				{
					n = i;
					dist = d;
				}
			}
			p = n;
			used[p] = true;
			ret.add(points[p]);
		} while (start != p);
		return ret;
	}
}
