// Solution to Float to Fraction
// Author: Thomas Beuman

// @EXPECTED_RESULTS@: CORRECT

/*
Solution (example):

x = 0.abc(defgh)
10^(3+5) * x = abcdefgh.(defgh)
10^3 * x = abc.(defgh)
(10^8 - 10^3) * x = abcdefgh - abc
x = (abcdefgh - abc) / (10^8 - 10^3)
*/

#include <cstdio>
using namespace std;

typedef long long i64;

// Returns greatest common divisor
i64 gcd (i64 a, i64 b)
{ return b ? gcd(b, a%b) : a;
}

// Returns 10^n
i64 power_of_ten (int n)
{ i64 power = 1ll;
  for (int i = 0; i < n; i++)
    power *= 10;
  return power;
}

int main()
{ int cases, casenr, i, part1, part2, n1, n2;
  i64 p, q, d;
  char digits[20];
  scanf("%d\n", &cases);
  for (casenr = 1; casenr <= cases; casenr++)
  { scanf("%s\n", digits);
    part1 = part2 = 0;
    // Read digits
    for (i = 2, n1 = 0; digits[i] != '(' && digits[i] != '\0'; i++, n1++)
      part1 = 10 * part1 + (digits[i]-'0');
    // Look for repeating pattern (if not present, set to 0)
    if (digits[i] == '(')
      for (i++, n2 = 0; digits[i] != ')'; i++, n2++)
        part2 = 10 * part2 + (digits[i]-'0');
    else
      n2 = 1;
    // Compute numerator and denominator
    p = (power_of_ten(n2)-1) * part1 + part2;
    q = power_of_ten(n1+n2) - power_of_ten(n1);
    // Reduce fraction
    d = gcd(p, q);
    printf("%lld/%lld\n", p/d, q/d);
  }
  return 0;
}

