// @EXPECTED_RESULTS@: CORRECT
#include <stdio.h>
#include <stdlib.h>
#include <assert.h>

static long long gcd(long long a, long long b)
{
    long long c;
    while (b) c = a%b, a = b, b = c;
    return a;
}

int main()
{
    char line[24];
    int cases = fgets(line, sizeof(line), stdin) ?  atoi(line) : 0;
    while (cases-- > 0 && fgets(line, sizeof(line), stdin))
    {
        const char *pos = line;
        long long a = 0, b = 1, f;

        /* Parse leading digits: */
        while (*pos >= '0' && *pos <= '9')
        {
            a = 10*a + (*pos++ - '0');
        }

        assert(*pos == '.');
        ++pos;

        /* Parse non-repeating decimal fraction: */
        while (*pos >= '0' && *pos <= '9')
        {
            a = 10*a + (*pos++ - '0');
            b = 10*b;
        }

        /* Parse repeating decimals: */
        if (*pos == '(')
        {
            long long c = 0, d = 0;
            ++pos;
            while (*pos >= '0' && *pos <= '9')
            {
                c = 10*c +(*pos++ - '0');
                d = 10*d + 9;
            }
            assert(*pos == ')');
            ++pos;

            /* Combine fractions: */
            a = a*d + c;
            b = b*d;
        }
        assert(*pos == '\n');

        /* Output a/b as a reduced fraction: */
        f = gcd(a, b);
        printf("%lld/%lld\n", a/f, b/f);
    }
    return 0;
}
