// Solution to Digital Transmission
// Author: Thomas Beuman

// Time complexity: O(n)
// Memory: O(n)

// @EXPECTED_RESULTS@: CORRECT

/*
Solution method: Dynamic programming

Keep track of the maximum number of zeros (and the maximum number of ones)
that one can put in the first m bits, for every set of values for the last two bits.

If there is a solution with enough 1's and one with enough 0's (and n is even),
then there is a solution with the right number of 1's and 0's.
*/

#include <cstdio>
#include <cstring>
#include <algorithm>
using namespace std;

char Code[100001];
int MaxBits[2][100001][4];
// ^ The maximum number of zeros/ones that can be put in the first m bits
// for every set of values for the last two bits (...00 = 0, ...01 = 1, ...10 = 2, ...11 = 3)

int main()
{ int cases, casenr, n, b, i, j, k, m0, m1;
  scanf("%d\n", &cases);
  for (casenr = 1; casenr <= cases; casenr++)
  { // Read input
    scanf("%s\n", Code);
    for (n = 0; Code[n] != '\0'; n++); // Determine length of code
    // Check if there is an odd number of bits
    if (n % 2)
    { printf("This is not supposed to happen!\n");
      continue;
    }
    memset(MaxBits, 128, sizeof(MaxBits)); // Initialize everything to "minus infinity"
    memset(MaxBits[0][0], 0, 4*sizeof(int)); // Initialize MaxBits[0][0][..] to 0
    memset(MaxBits[1][0], 0, 4*sizeof(int)); // Initialize MaxBits[1][0][..] to 0
    for (i = 1; i <= n; i++)
      for (j = 0; j < 2; j++) // Try 0 and 1
        if (Code[i-1] != '0'+j) // Check if Code[i-1] is already given (and not equal to j)
          for (k = 0; k < 4; k++) // Consider all possible values for the last two bits
            if (k != 3*j) // Check if we get three 0's or 1's in a row
              for (b = 0; b < 2; b++) // For both the maximum number of 0's and 1's
                // New final sequence = 2 * (last bit of k) + j
                MaxBits[b][i][2*(k%2)+j] = max(MaxBits[b][i][2*(k%2)+j], MaxBits[b][i-1][k] + (b==j?1:0));
    // Get the final maximum numbers
    m0 = m1 = 0;
    for (i = 0; i < 4; i++)
    { m0 = max(m0, MaxBits[0][n][i]);
      m1 = max(m1, MaxBits[1][n][i]);
    }
    // Check if we can get enough 1's and enough 0's
    printf("%s\n", m0 >= n/2 && m1 >= n/2 ? "yes" : "no");
  }
  return 0;
}

