/*
@EXPECTED_RESULTS@: CORRECT

Let's call a `valid string' a string that matches the given pattern and does
not contain overlong runs, but does not necessarily have equal numbers of ones
and zeroes.  The digit sum of such a string is the number of 1s in the string.
The question is: does a valid string with digit sum n/2 exist?

Claim: if it is possible to create two valid strings with digit sums x and y,
then strings with every digit sum between x and y exist too.

Assuming this, a straightforward solution is to compute the minimum and maximum
possible digit sum (using dynamic programming in O(n) time and O(1) space); the
answer is `yes' iff. n is even and n/2 falls within the computed range.

Proof of the claim: let s and t be valid strings and sum t - sum s > 1.  Then
there must be some position i such that sum s[:i) = sum t[:i), sum s[:i+1) <
sum t[:i+1) and sum s[:i+2) < sum t[:i+2).  There are exactly three ways to
decompose s and t at position i = len a = len b:

  s = a00c  then  s+ = b10c  is a valid string
  t = b10d

  s = a01c  then  t- = a01d  is a valid string
  t = b11d

  s = a00c  then both s+ and t- as defined above are valid strings
  t = b11d

Note that the three cases above are the only ones that are possible, and that
sum s+ = sum s + 1, while sum t- = sum t - 1.  This means we can always reduce
our range by one and by induction construct all digit sums in between. */

#include <assert.h>
#include <stdio.h>
#include <string.h>

static int min(int a, int b) { return a < 0 ? b : b < 0 ? a : a < b ? a : b; }
static int max(int a, int b) { return a < 0 ? b : b < 0 ? a : a > b ? a : b; }
static int inc(int n) { return n < 0 ? n : n + 1; }

int main(int argc, char *argv[])
{
    int cases;
    if (scanf("%d\n", &cases) != 1) return 1;
    while (cases--)
    {
        char ch;
        int lo, hi, n;
        int mn[4] = { 0, 0, 0, 0 };  /* 00, 0, 1, 11 */
        int mx[4] = { 0, 0, 0, 0 };  /* 00, 0, 1, 11 */
        for (n = 0; (ch = getchar()) != '\n'; ++n)
        {
            int next_mn[5] = { -1, -1, -1, -1 };
            int next_mx[5] = { -1, -1, -1, -1 };
            if (ch != '1')
            {
                next_mn[0] = mn[1];
                next_mn[1] = min(mn[2], mn[3]);
                next_mx[0] = mx[1];
                next_mx[1] = max(mx[2], mx[3]);
            }
            if (ch != '0')
            {
                next_mn[2] = inc(min(mn[0], mn[1]));
                next_mn[3] = inc(mn[2]);
                next_mx[2] = inc(max(mx[0], mx[1]));
                next_mx[3] = inc(mx[2]);
            }
            memcpy(mn, next_mn, sizeof(mn));
            memcpy(mx, next_mx, sizeof(mx));
        }
        lo = min(min(mn[0], mn[1]), min(mn[2], mn[3]));
        hi = max(max(mx[0], mx[1]), max(mx[2], mx[3]));
        assert(n > 0 && n%2 == 0);
        assert((lo == -1) == (hi == -1));
        if (argc > 1 && strcmp(argv[1], "-d") == 0)
        {
            fprintf( stderr, "%d <= %d <= %d\n", lo, n/2, hi );
        }
        printf("%s\n", (lo <= n/2 && n/2 <= hi) ? "yes": "no");
    }
    return 0;
}
