// Solution to Bad Scientist
// Author: Thomas Beuman

// Time complexity: O(n * 2^k) ?
// Memory: O(n^2)

// @EXPECTED_RESULTS@: CORRECT

/*
Solution outline:

Recursively process all theories.
If no decision was made yet, try keeping and discarding it.
In case of keeping it, discard all the theories that contradict it.
In both cases, move on to the next theory.

Keep track of the number of rejections so far and abort when it reaches the best solution so far.

This solution keeps track of all decisions in a vector which is passed on by value.
*/

#include <cstdio>
#include <cstring>
#include <vector>
using namespace std;

enum {undecided, keep, discard};

int n, best;
bool Contradiction[50][50], Single[50];

void rec (int t, int rejects, vector<int> Status)
{ if (rejects >= best) // If we are not going to get a better solution, we can abort
    return;
  if (t == n) // All theories have been processed; we have a new best solution
  { best = rejects;
    return;
  }
  // Theory t has no conflicts with any other theories, or it was already discarded;
  // proceed with the next theory
  if (Single[t] || Status[t] != undecided)
  { rec(t+1, rejects, Status);
    return;
  }
  int i;
  // Try discarding theory t
  Status[t] = discard;
  rec(t+1, rejects+1, Status);
  // Try keeping it
  Status[t] = keep;
  for (i = t+1; i < n; i++)
    if (Contradiction[t][i] && Status[i] == undecided)
    { Status[i] = discard;
      rejects++;
    }
  rec(t+1, rejects, Status);
  return;
}

int main()
{ int cases, casenr, k, m, i, a, b;
  vector<int> Status;
  scanf("%d\n", &cases);
  for (casenr = 1; casenr <= cases; casenr++)
  { // Read input
    scanf("%d\n%d\n%d\n", &n, &k, &m);
    memset(Contradiction, false, sizeof(Contradiction));
    memset(Single, true, sizeof(Single));
    for (i = 0; i < m; i++)
    { scanf("%d %d\n", &a, &b);
      Contradiction[a-1][b-1] = Contradiction[b-1][a-1] = true;
      Single[a-1] = Single[b-1] = false;
    }
    // Initialization
    Status = vector<int>(n, undecided);
    best = k+1; // Best solution so far
    rec(0, 0, Status); // Look for best solution
    // Output
    if (best <= k)
      printf("%d\n", best);
    else
      printf("IMPOSSIBLE\n");
  }
  return 0;
}

