-- @EXPECTED_RESULTS@: CORRECT
import Control.Monad

solve :: Int -> [[Int]] -> Maybe Int
solve limit [] = Just limit
solve 0     _  = Nothing
solve limit (conflict:rest) = maximum (map discard conflict)
    where discard theory = solve (limit - 1) (filter (notElem theory) rest)

doCase = do
    _theorems <- getLine
    limit <- readLn
    conflicts <- readLn >>= (`replicateM` liftM (map read.words) getLine)
    case solve limit conflicts of
        Nothing   -> putStrLn "IMPOSSIBLE"
        Just left -> print (limit - left)

main = readLn >>= (`replicateM` doCase)
