-- @EXPECTED_RESULTS@: CORRECT
import Control.Monad
import Data.Ord (comparing)
import Data.List (delete, minimumBy)

data Trie = Node Bool [(Char,Trie)]

insert :: Trie -> String -> Trie
insert (Node term children) ""     = Node True children
insert (Node term children) (l:ls) = Node term (insertChild children)
    where insertChild []               = [(l, insert (Node False []) ls)]
          insertChild ((c,child):rest) | c == l     = (l,insert child ls):rest
                                       | otherwise  = (c,child):insertChild rest

find :: Trie -> String -> [String]
find (Node term children) letters 
    = ["" | term] ++ concat [ map (l:) $ find child (delete l letters) |
                              (l, child) <- children, l `elem` letters ]

main = readTrie >>= doCases
   where
         readLines = readLn >>= (`replicateM` getLine)

         readTrie = liftM (foldl insert (Node False [])) readLines

         doCases trie = readLines >>= mapM_ (putStrLn . best . find trie)
             where best []    = "IMPOSSIBLE"
                   best words = minimumBy (comparing comp) words
                   comp word  = (-length word, word)
