// @EXPECTED_RESULTS@: CORRECT
#include <algorithm>
#include <iostream>
#include <map>
#include <string>
using namespace std;

static map<string, string> dictionary;

static string solve(string word)
{
    string answer;
    sort(word.begin(), word.end());
    for (unsigned mask = 1; mask != (1 << word.size()); ++mask)
    {
        string k;
        for (unsigned i = 0; i < word.size(); ++i)
            if (mask & (1 << i)) k += word[i];
        map<string, string>::const_iterator it = dictionary.find(k);
        if (it == dictionary.end()) continue;
        const string &word = it->second;
        if ( word.size() > answer.size() || (word.size() == answer.size() &&
                word < answer) ) answer = word;
    }
    return answer.empty() ? "IMPOSSIBLE" : answer;
}

int main()
{
    string word;
    int words = 0;
    cin >> words;
    while (words-- > 0 && cin >> word)
    {
        string key = word;
        sort(key.begin(), key.end());
        string &entry = dictionary[key];
        if (entry.empty()) entry = word;
    }
    cin >> words;
    while (words-- > 0 && cin >> word) cout << solve(word) << endl;
}
