/*
 * @EXPECTED_RESULTS@: CORRECT
 */
using System;

public class jeroen
{
	public static int[] dr = { 0, 1, 1, 0, -1, -1 };
	public static int[] dc = { -1, 0, -1, 1, 0, 1 };
	public static int N;
	public static string[] grid;
	public static bool[,] done;

	public static void Main(string[] args)
	{
		int tests = int.Parse(Console.ReadLine());
		for(int testcase = 1; testcase <= tests; testcase++)
		{
			N = int.Parse(Console.ReadLine());
			grid = new string[N];
			for(int i = 0; i < N; i++)
				grid[i] = Console.ReadLine();

			// Validate input
			int numw = 0;
			int numb = 0;
			for(int i = 0; i < N; i++)
			{
				for(int j = 0; j < N; j++)
				{
					if(grid[i][j] == 'W') numw++;
					if(grid[i][j] == 'B') numb++;
				}
			}
			if(numw != numb && numw + 1 != numb)
				throw new Exception("Case " + testcase + ": White = " + numw + "; Black = " + numb);

			// White wins?
			done = new bool[N,N];
			for(int i = 0; i < N; i++)
				dfs(i, 0, 'W');
			bool win = false;
			for(int i = 0; i < N; i++)
				if(done[i,N-1])
					win = true;
			if(win)
			{
				Console.WriteLine("White wins");
				continue;
			}

			// Black wins?
			done = new bool[N,N];
			for(int i = 0; i < N; i++)
				dfs(0, i, 'B');
			win = false;
			for(int i = 0; i < N; i++)
				if(done[N-1,i])
					win = true;
			if(win)
			{
				Console.WriteLine("Black wins");
				continue;
			}

			Console.WriteLine("Not finished");
		}
	}

	public static void dfs(int r, int c, char v)
	{
		if(r < 0 || r >= N || c < 0 || c >= N || done[r,c] || grid[r][c] != v) return;
		done[r,c] = true;
		for(int i = 0; i < 6; i++)
			dfs(r+dr[i], c+dc[i], v);
	}
}