/*
 * @EXPECTED_RESULTS@: CORRECT
 */
using System;
using System.Linq;
using System.Collections.Generic;

public class jeroen
{
	public static void Main(string[] args)
	{
		// Let C# always use '.' for outputting doubles
		System.Threading.Thread.CurrentThread.CurrentCulture = System.Globalization.CultureInfo.InvariantCulture;

		int tests = int.Parse(Console.ReadLine());
		while(tests-- > 0)
		{
			Point luke = new Point(Console.ReadLine());
			Point escape = new Point(Console.ReadLine());
			int n = int.Parse(Console.ReadLine());
			Point[] points = new Point[n+2];
			points[0] = luke;
			points[1] = escape;
			for(int i = 0; i < n; i++)
				points[i+2] = new Point(Console.ReadLine());

			// Validate input
			HashSet<Point> hs = new HashSet<Point>();
			for(int i = 0; i < points.Length; i++)
				if(!hs.Add(points[i]))
					throw new Exception("Duplicate points found: " + points[i]);

			// Find Convex hull of all points
			Point[] hull = ConvexHull(points, true);

			// Find locations of luke and escape hatch on hull
			int start = 0;
			while(start < hull.Length && hull[start] != luke) start++;
			int end = 0;
			while(end < hull.Length && hull[end] != escape) end++;

			if(start == hull.Length && end == hull.Length)
			{ // Neither of them on the hull, then it's impossible
				Console.WriteLine("IMPOSSIBLE");
			}
			else if(start == hull.Length || end == hull.Length)
			{
				// If one of them is on the hull, the other one might
				// be on there when removing this one, then none of them
				// is actually in between the Daltons
				Point[] points2 = new Point[n+1];
				Array.Copy(points, 1, points2, 0, n+1);
				points2[0] = start == hull.Length ? luke : escape;
				Point[] hull2 = ConvexHull(points2, true);
				if((start == hull.Length && hull2.Contains(luke))
					 || (end == hull.Length && hull2.Contains(escape)))
					Console.WriteLine("{0:0.000}", Distance(luke,escape) + 1e-6);
				else
					Console.WriteLine("IMPOSSIBLE");
			}
			else
			{
				// Try two ways of walking around all Dalton's
				double dst1 = 0;
				for(int i = start; i != end; i = (i+1)%hull.Length)
					dst1 += Distance(hull[i], hull[(i+1)%hull.Length]);
				double dst2 = 0;
				for(int i = start; i != end; i = (i+hull.Length-1)%hull.Length)
					dst2 += Distance(hull[i], hull[(i+hull.Length-1)%hull.Length]);
				// Print output, +1e-6 is for checking invariant from problem statement
				Console.WriteLine("{0:0.000}", Math.Min(dst1, dst2) + 1e-6);	
			}
		}
	}

	public class Point
	{
		public int X, Y;
		
		public Point(string s)
		{
			string[] p = s.Split();
			X = int.Parse(p[0]);
			Y = int.Parse(p[1]);
		}

		public override bool Equals(object other)
		{
			Point oth = other as Point;
			if(oth == null) return false;
			return X == oth.X && Y == oth.Y;
		}
		
		public override int GetHashCode()
		{
			return X ^ (9 * Y);
		}

		public override string ToString()
		{
			return X + " " + Y;
		}
	}

	public static double Distance(Point A, Point B)
	{
		return Math.Sqrt((long)(A.X - B.X) * (A.X - B.X) + (long)(A.Y - B.Y) * (A.Y - B.Y));
	}


	/* Calculates convex hull of a set of poins
	 * in O(N^2). This is not efficient but fine
   * for this problem.
	 */
	public static Point[] ConvexHull(Point[] points, bool onEdge)
	{
		int p = 0, i, start, n;
		long cr, dist, d;
		int N = points.Length;
		bool[] used = new bool[N];

		if(N <= 3) return points;

		for (i = 1; i < N; i++)
			if (points[i].X < points[p].X || (points[i].X == points[p].X && points[i].Y > points[p].Y))
				p = i;

		start = p;
		List<Point> ret = new List<Point>();
		do
		{
			n = -1;
			dist = onEdge ? long.MaxValue : 0;
			for (i = 0; i < N; i++)
			{
				if (i == p || used[i]) continue;
				if (n == -1) n = i;
				cr = (long)(points[i].X - points[p].X) * (points[n].Y - points[p].Y) - (long)(points[i].Y - points[p].Y) * (points[n].X - points[p].X);
				d = (long)(points[i].X - points[p].X) * (points[i].X - points[p].X) + (long)(points[i].Y - points[p].Y) * (points[i].Y - points[p].Y);
				if (cr < 0 || (cr == 0 && i != start && ((onEdge && d < dist) || (!onEdge && d > dist))))
				{
					n = i;
					dist = d;
				}
			}
			p = n;
			used[p] = true;
			ret.Add(points[p]);
		} while (start != p);
		return ret.ToArray();
	}
}
