{-  Dynamic-programming based solution for the general problem (with variable
    run-length limit).  Takes O(n * maxRun^2) time.

    @EXPECTED_RESULTS@: CORRECT
-}
import Control.Monad
import Data.List
import Data.Function
import Data.Maybe

data Prefix = Prefix { val :: Int,  -- value of the last bit
                       run :: Int,  -- run length for the last bit
                       tot :: Int } -- total digit sum of the entire prefix

maxRun = 2  -- maximum run length allowed

minSumBy :: (Int -> Int -> Ordering) -> String -> Maybe Int
minSumBy cmp line
    = case foldl extendPattern [Prefix 0 0 0] line of
        [] -> Nothing
        xs -> Just (minimumBy cmp (map tot xs))
    where
        -- Extend all prefixes consistent with the given (wildcard) character:
        extendPattern pres '.' = extendAll 0 pres ++ extendAll 1 pres
        extendPattern pres '0' = extendAll 0 pres
        extendPattern pres '1' = extendAll 1 pres

        -- Extend all possible prefixes by one bit:
        extendAll :: Int -> [Prefix] -> [Prefix]
        extendAll bit = nubBy ((==) `on` run) . sortBy (cmp `on` tot) .
                        mapMaybe (extend bit)

        -- Return the prefix extended by one bit (if possible)
        extend :: Int -> Prefix -> Maybe Prefix
        extend bit pre
            | bit /= val pre   = Just (Prefix bit 1 (tot pre + bit))
            | run pre < maxRun = Just (Prefix bit (run pre + 1) (tot pre + bit))
            | otherwise        = Nothing

minSum = minSumBy compare
maxSum = minSumBy (flip compare)

solve line = case (length line `divMod` 2, minSum line, maxSum line) of
                ((n, 0), Just lo, Just hi) -> lo <= n && n <= hi
                otherwise                  -> False

doCase = do line <- getLine
            putStrLn (if solve line then "yes" else "no")

main = readLn >>= (`replicateM_` doCase)
