// Solution to Cubing
// Author: Thomas Beuman

// @EXPECTED_RESULTS@: CORRECT

// Solution method: just do it

#include <cstdio>
using namespace std;

/*
Layout
              **************
              * U0  U1  U2 *
              *            *
              * U7      U3 *
              *            *
              * U6  U5  U4 *
 *****************************************************
 * L0  L1  L2 * F0  F1  F2 * R0  R1  R2 * B0  B1  B2 *
 *            *            *            *            *
 * L7      L3 * F7      F3 * R7      R3 * B7      B3 *
 *            *            *            *            *
 * L6  L5  L4 * F6  F5  F4 * R6  R5  R4 * B6  B5  B4 *
 *****************************************************
              * D0  D1  D2 *
              *            *
              * D7      D3 *
              *            *
              * D6  D5  D4 *
              **************
*/

enum {U, D, F, B, L, R};
char Color[7] = "wyrogb";

// Description of clockwise rotations
char Rotation[6][45] = {"F2-F1-F0 -> L2-L1-L0 -> B2-B1-B0 -> R2-R1-R0",  // Up face
                        "F6-F5-F4 -> R6-R5-R4 -> B6-B5-B4 -> L6-L5-L4",  // Down face
                        "U6-U5-U4 -> R0-R7-R6 -> D2-D1-D0 -> L4-L3-L2",  // Front face
                        "U2-U1-U0 -> L0-L7-L6 -> D6-D5-D4 -> R4-R3-R2",  // Back face
                        "U0-U7-U6 -> F0-F7-F6 -> D0-D7-D6 -> B4-B3-B2",  // Left face
                        "U4-U3-U2 -> B0-B7-B6 -> D4-D3-D2 -> F4-F3-F2"}; // Right face

char* Square[6][4][3]; // Pointers to the squares involved in each rotation
char Cube[6][8]; // Colors

// Permutes the contents of four squares
void cycle (char& c1, char& c2, char&c3, char& c4, bool forward)
{ char t = c1;
  if (forward)
  { c1 = c4;  c4 = c3;  c3 = c2;  c2 = t;
  }
  else
  { c1 = c2;  c2 = c3;  c3 = c4;  c4 = t;
  }
}

int main()
{ int cases, casenr, n, i, j, k, face;
  bool dir;
  char Turns[3001];
  int C['z'];
  C['U'] = U; C['F'] = F; C['L'] = L;
  C['D'] = D; C['B'] = B; C['R'] = R;
  // Read the descriptions in Rotation[][]
  for (i = 0; i < 6; i++)
    for (j = 0; j < 4; j++)
      for (k = 0; k < 3; k++)
        Square[i][j][k] = &Cube[ C[(int)Rotation[i][12*j+3*k]] ][ Rotation[i][12*j+3*k+1] - '0' ];
  scanf("%d\n", &cases);
  for (casenr = 1; casenr <= cases; casenr++)
  { scanf("%d\n", &n);
    fgets(Turns, 3001, stdin);
    // Reset the cube
    for (i = 0; i < 6; i++)
      for (j = 0; j < 8; j++)
        Cube[i][j] = Color[i];
    for (i = 0; i < n; i++)
    { face = C[(int)Turns[3*i]];
      dir = (Turns[3*i+1] == '+');
      cycle(Cube[face][0], Cube[face][2], Cube[face][4], Cube[face][6], dir); // Corner squares
      cycle(Cube[face][1], Cube[face][3], Cube[face][5], Cube[face][7], dir); // Edge squares
      // Squares from the adjacent faces
      for (k = 0; k < 3; k++)
        cycle(*Square[face][0][k], *Square[face][1][k], *Square[face][2][k], *Square[face][3][k], dir);
    }
    printf("%c%c%c\n%cw%c\n%c%c%c\n", Cube[U][0], Cube[U][1], Cube[U][2], Cube[U][7], Cube[U][3], Cube[U][6], Cube[U][5], Cube[U][4]);
  }
  return 0;
}

