// Solution to Bad Scientist
// Author: Thomas Beuman

// Time complexity: O(bin(n,k) * 2^k) (worst case)
// Memory: O(n^2)

// @EXPECTED_RESULTS@: TIMELIMIT

/*
Solution outline:

Recursively process all theories.
If no decision was made yet, try keeping and discarding it.
In case of keeping it, discard all the theories that contradict it.
In both cases, move on to the next theory.

Keep track of the number of rejections so far and abort when it reaches the best solution so far.

This solution fails if there are a lot of theories without any contradicting partners.
*/

#include <cstdio>
#include <cstring>
using namespace std;

const int undecided = -2, keep = -1;

int n, best;
bool Contradiction[50][50];
int Status[50];

void rec (int t, int rejects)
{ if (rejects >= best) // If we are not going to get a better solution, we can abort
    return;
  if (t == n) // All theories have been processed; we have a new best solution
  { best = rejects;
    return;
  }
  if (Status[t] != undecided) // It was already discarded; proceed with the next theory
  { rec(t+1, rejects);
    return;
  }
  // Try discarding theory t
  Status[t] = t;
  rec(t+1, rejects+1);
  // Try keeping it
  Status[t] = keep;
  int i;
  // Discard all contradicting theories (that have not yet been discarded)
  for (i = t+1; i < n; i++)
    if (Contradiction[t][i] && Status[i] == undecided)
    { Status[i] = t;
      rejects++;
    }
  rec(t+1, rejects);
  // Set the status of the theories that were discarded above back to undecided
  for (i = t+1; i < n; i++)
    if (Status[i] == t)
      Status[i] = undecided;
  // Set the status of theory t back to undecided and return
  Status[t] = undecided;
  return;
}

int main()
{ int cases, casenr, k, m, i, a, b;
  scanf("%d\n", &cases);
  for (casenr = 1; casenr <= cases; casenr++)
  { // Read input
    scanf("%d\n%d\n%d\n", &n, &k, &m);
    memset(Contradiction, false, sizeof(Contradiction));
    for (i = 0; i < m; i++)
    { scanf("%d %d\n", &a, &b);
      Contradiction[a-1][b-1] = Contradiction[b-1][a-1] = true;
    }
    // Initialization
    for (i = 0; i < n; i++)
      Status[i] = undecided;
    best = k+1; // Best solution so far
    rec(0, 0); // Look for best solution
    // Output
    if (best <= k)
      printf("%d\n", best);
    else
      printf("IMPOSSIBLE\n");
  }
  return 0;
}

