uses
	math, testlib, sysutils;

const
	maxn = 50;

var
	a, c, f: array [1..maxn, 1..maxn] of longint;
	n: longint;
	u: array [1..maxn] of boolean;

function dfs(x, t: longint; cl: longint): longint;
var
	i, r: longint;
begin
	if x = t then begin
		dfs := cl;
		exit;
	end;
	u[x] := true;
	for i := 1 to n do begin
		if not u[i] and (f[x][i] < c[x][i]) then begin
			r := dfs(i, t, min(cl, c[x][i] - f[x][i]));
			if (r > 0) then begin
				dfs := r;
				f[x][i] := f[x][i] + r;
				f[i][x] := f[i][x] - r;
				exit;
			end;
		end;
	end;
	dfs := 0;
end;

function flow(s, t: longint): longint;
var
	dr, r: longint;
begin
	r := 0;
	fillchar(f, sizeof(f), 0);
	while true do begin
		fillchar(u, sizeof(u), false);
		dr := dfs(s, t, maxlongint);
		if dr = 0 then
			break;
		r := r + dr;
	end;
	flow := r;
end;

var
	ja, pa: string;
	m, fl, i, j, k, cap: longint;

begin
	ja := ans.readword(blanks, blanks);
	pa := uppercase(ouf.readword(blanks, blanks));

	if (pa <> 'YES') and (pa <> 'NO') then
		quit(_pe, format('YES or NO expected, "%s" found', [pa]));

	if (pa = 'NO') then begin
		if ja = 'NO' then
			quit(_ok, 'NO')
		else
			quit(_wa, 'NO unexpected')
	end;                                                        

	n := inf.readlongint;
	for i := 1 to n do begin
		for j := 1 to n do begin
			a[i][j] := inf.readlongint;
		end;
	end;

	m := ouf.readlongint;
	for i := 1 to m do begin
		j := ouf.readlongint;
		k := ouf.readlongint;
		if (j < 1) or (j > n) or (k < 1) or (k > n) or (j = k) then
			quit(_wa, format('invalid edge: %d-%d', [j, k]));
		if (c[j][k] > 0) then
			quit(_wa, format('duplicate edge: %d-%d', [j, k]));
		cap := ouf.readlongint;
		if (cap <= 0) or (cap > 1000) then
			quit(_wa, format('invalid capacity for edge %d-%d: %d', [j, k, cap]));
		c[j][k] := cap;
		c[k][j] := cap;
	end;

	for i := 1 to n do begin
		for j := i + 1 to n do begin
			fl := flow(i, j);
			if fl <> a[i][j] then
				quit(_wa, format('cut between %d and %d - expected: %d, found: %d', [i, j, a[i][j], fl]));
		end;
	end;

	if ja = 'NO' then
		quit(_fail, 'NO expected');

	quit(_ok, '');
end.