#include "testlib.h"
#include <cmath>
#include <math.h>

using namespace std;

const double EPS = 1E-2;

int main(int argc, char * argv[])
{
    setName("compare two sequences of doubles, maximal absolute error = %.10lf", EPS);
    registerTestlibCmd(argc, argv);

    int n = 0;
    while (!ans.seekEof()) 
    {
        n++;
        double j = ans.readDouble();
        double p = ouf.readDouble();
        if (isnan(p)) 
         quitf (_wa,"%d%s number: NAN found",n,englishEnding(n).c_str());
        if (isnan(j)) 
         quitf (_fail,"%d%s number: NAN found",n,englishEnding(n).c_str());
        if (isinf(p)) 
         quitf (_wa,"%d%s number: INFINITY found",n,englishEnding(n).c_str());
        if (isinf(j)) 
         quitf (_fail,"%d%s number: INFINITY found",n,englishEnding(n).c_str());
        if (fabs(j - p) > EPS + 1E-15)
            quitf(_wa, "%d%s numbers differ - expected: '%.10lf', found: '%.10lf'", n, englishEnding(n).c_str(), j, p);
    }

    quitf(_ok, "%d numbers", n);
}
