//#pragma comment(linker, "/STACK:100000000")
#include <stdio.h>
#include <vector>
#include <stdlib.h>
#include <assert.h>
#include <algorithm>
#include <set>

#define MAXV 2000
#define MAXE 100000

using namespace std;

struct Edge {
	int u, v;
	bool isBridge;
	Edge (int u0 = 0, int v0 = 0) {
		u = u0; v = v0; isBridge = false;
	}
	inline int to(int i) { return u ^ v ^ i; }
};

vector<Edge> edges;
vector<int> adj[MAXV];
int n, m;

void link(int u, int v) {
	int i = edges.size();
	edges.push_back( Edge(u, v) );
	adj[u].push_back( i );
	adj[v].push_back( i );
}

int ccc[MAXV];

int findParent(int x) { if (x != ccc[x]) ccc[x] = findParent(ccc[x]); return ccc[x]; }
void join(int x, int y) { x = findParent(x); y = findParent(y); if (rand() & 1) ccc[x] = y; else ccc[y] = x; }

bool isConnected(int supa, int supb) {
	int i, j, k, c = n;
	for (i = 0; i < n; i++) ccc[i] = i;
	for (i = 0; i < edges.size() && c > 1; i++) {
		if (i == supa || i == supb) continue;
		if (findParent(edges[i].u) != findParent(edges[i].v)) { join(edges[i].u, edges[i].v); c--; }
	}
	return c == 1;
}

long long res;
int enter[MAXV], low[MAXV], currTime, bridgesCount;
bool used[MAXV];
int cnt[MAXV][MAXV], high[MAXV];
vector<int> dp[MAXV];
vector<int> treeAdj[MAXV];

void dfs(int u, int p) {
	int i, j, e, v;

	used[u] = true;
	enter[u] = low[u] = currTime++;
	dp[u].clear();
	for (i = 0; i <= enter[u]; i++) cnt[u][i] = 0;
	treeAdj[u].clear();

	int temp2 = enter[u];
	for (i = 0; i < adj[u].size(); i++) {
		e = adj[u][i]; v = edges[e].to(u);
		if (e == p) continue;
		if (used[v]) { cnt[u][enter[v]]++; temp2 = min(temp2, enter[v]); low[u] = min(low[u], enter[v]); continue; }
		treeAdj[u].push_back(e);
		dfs(v, e);
		if (low[v] == enter[v]) { edges[e].isBridge = true; bridgesCount++; }
		low[u] = min(low[u], low[v]);
		for (j = 0; j <= enter[u]; j++) cnt[u][j] += cnt[v][j];
	}

	for (i = 0; i < treeAdj[u].size(); i++) dp[u].push_back( temp2 );
	int temp = temp2;
	for (i = 0; i < treeAdj[u].size(); i++) {
		e = treeAdj[u][i]; v = edges[e].to(u);
		dp[u][i] = min(dp[u][i], temp);
		temp = min(temp, low[v]);
	}
	temp = temp2;
	for (i = treeAdj[u].size() - 1; i >= 0; i--) {
		e = treeAdj[u][i]; v = edges[e].to(u);
		dp[u][i] = min(dp[u][i], temp);
		temp = min(temp, low[v]);
	}
	high[u] = enter[u];  for (i = enter[u] - 1; i >= 0; i--) if (cnt[u][i]) { high[u] = i; break; }
}

void dfs3(int v, int q, int u, int p, int currMin) {
	if (q != p && !edges[q].isBridge) {
		int temp = 0;
		if (currMin < enter[u]) temp++;
		if (low[v] < enter[u]) temp++;
		if (high[v] >= enter[u]) temp++;
		if (temp < 2) res++;
	}

	for (int i = 0; i < treeAdj[v].size(); i++) {
		int e = treeAdj[v][i];
		dfs3(edges[e].to(v), e, u, p, min(currMin, dp[v][i]));
	}
}

void dfs2(int u, int p) {
	int i, e, v;
	int temp = 0;

	if (p >= 0) for (i = 0; i <= enter[edges[p].to(u)] && temp <= 1; i++) temp += cnt[u][i];
	if (p >= 0 && temp == 1) res++;

	if (p >= 0 && !edges[p].isBridge) dfs3(u, p, u, p, n);

	for (i = 0; i < treeAdj[u].size(); i++) {
		e = treeAdj[u][i]; v = edges[e].to(u);
		dfs2(v, e);
	}
}

int main(void) {
	int i, j, k, u, v;
	freopen("network.in", "rt", stdin);
	freopen("network.out", "wt", stdout);
	while (scanf("%d%d", &n, &m) == 2 && n) {
		edges.clear(); for (i = 0; i < n; i++) adj[i].clear();
		for (i = 0; i < m; i++) {
			int ret = scanf("%d%d", &u, &v);
			assert( ret == 2 );
			assert( u >= 1 && u <= n && v >= 1 && v <= n );
			link(u - 1, v - 1);
		}
		assert( isConnected(-1, -1) );

		for (i = 0; i < n; i++) used[i] = false;
		currTime = 0; bridgesCount = 0;
		dfs(0, -1);
		res = bridgesCount * (m - bridgesCount) + ((long long)bridgesCount * (bridgesCount - 1)) / 2;

		dfs2(0, -1);

		//long long res2 = 0;
		//for (i = 0; i < m; i++) for (j = i + 1; j < m; j++) if (!isConnected(i, j)) { /*printf("(%d %d,%d %d)\n", edges[i].u + 1, edges[i].v + 1, edges[j].u + 1, edges[j].v + 1);*/ res2++; }
		//assert(res2 == res);
		printf("%Ld\n", res);
	}
	return 0;
}

